'''
Created on 2019年8月23日
@author: GongQingBao
数据采集器-上行.
'''
import json
import socket
import struct
import threading
import traceback
import time
from threading import Thread

from H_9U.conf.syssettings import SysSettings
from H_9U.ctrl.sender.Sender import sender
from H_9U.ctrl.up.evt.boxEvt import BoxEvent
from H_9U.ctrl.up.evt.fiberModeChangedEvt import FiberModeChangedEvent
from H_9U.ctrl.up.evt.inputSourceChangedEvt import InputSourceChangedEvent
from H_9U.ctrl.up.evt.inputSourceUsedEvt import InputSourceUsedEvent
from H_9U.ctrl.up.evt.inputSubSourceListEvt import InputSubSourceListEvt
from H_9U.ctrl.up.evt.ipcOnlineEvt import IpcOnlineEvent
from H_9U.ctrl.up.evt.layerChangedEvt import LayerChangedEvent
from H_9U.ctrl.up.evt.ledShutDownEvt import LedShutDownEvent
from H_9U.ctrl.up.evt.mvrGroupPollStatusEvt import MvrGroupPollStatusEvent
from H_9U.ctrl.up.evt.noTimeSourceDataChangeEvt import NoTimeSourceDataChangeEvt
from H_9U.ctrl.up.evt.presetDataEvt import PresetDataEvent
from H_9U.ctrl.up.evt.screenLed3dEvt import ScreenLed3dEvent
from H_9U.ctrl.up.evt.screenLedOsdEvt import ScreenLedOsdEvent
from H_9U.ctrl.up.evt.slotEvt import SlotEvent
from H_9U.ctrl.up.evt.presetEvt import PresetPoolEvent
from H_9U.ctrl.up.evt.sourceDataChangeEvt import SourceDataChangeEvent
from H_9U.ctrl.up.evt.upgradeEvt import UpgradeEvent
from H_9U.ctrl.up.evt.screenBrightnessEvt import ScreenBrightnessEvent
from H_9U.ctrl.up.evt.screenHDREvt import ScreenHDREvent
from H_9U.ctrl.up.evt.hdrSupportEvt import HDRSupportEvent
from H_9U.ctrl.up.evt.ipcUrlEvt import IPCUrlEvent
from H_9U.ctrl.up.evt.stdiocardEvt import STDIOCardEvent
from H_9U.ctrl.up.evt.outputbakcupEvt import OutputBackupCardEvent
from H_9U.ctrl.up.evt.languagemodeEvt import LanguageModeEvent
from H_9U.ctrl.up.evt.ipcMontageEvt import IPCMontageEvent
from H_9U.ctrl.up.evt.videoStreamEvt import VideoStreamEvent
from H_9U.ctrl.up.evtSender import EvtSender
from H_9U.ctrl.up.evtType import EvtType
from H_9U.ctrl.up.evt.screenAudioEvt import ScreenAudioEvent
from H_9U.ctrl.up.evt.genLockEvt import GenLockEvent
from H_9U.ctrl.up.evt.deviceTimeEvt import DeviceTimeEvent
from H_9U.ctrl.up.evt.osdWeatherEvt import OSDWeatherEvent
from H_9U.util.log import logger


class Collector(object):

    def __init__(self):
        # 在timer中创建Socket-UDP,目的：不阻塞主进程
        Thread(target=self.run).start()

    def run(self):
        """在线程中创建Socket-UDP
        """
        logger.info("Collector初始化线程开始...")
        while True:
            try:
                self.initUdp()
            except Exception:
                msg = traceback.format_exc()
                logger.error('Collector初始化线程时-异常:%s' % (msg))
            time.sleep(10)

    #     def initUdp(self):
    #         """初始化UDP
    #         """
    #         s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM);     # ipv4、SOCK_DGRAM指定了这个Socket的类型是UDP
    #         s.bind((SysSettings.UDP_UP_IP, SysSettings.UDP_UP_PORT)); # 绑定 客户端口和地址
    #
    #         while True:
    #             data, addr = s.recvfrom(self.buffSize); # 接收数据 自动阻塞 等待客户端请求:
    #
    #             s.sendto('Hello, 你好!'.encode(), addr);
    #             #recvfrom()方法返回数据和客户端的地址与端口，这样，服务器收到数据后，直接调用sendto()就可以把数据用UDP发给客户端。

    def initUdp(self):
        """初始化UDP,并进入数据接收状态
        """
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM, socket.IPPROTO_UDP)
        s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        s.bind(('', SysSettings.MULTICAST_PORT))

        mreq = struct.pack("4sl", socket.inet_aton(SysSettings.MULTICAST_ADDRESS), socket.INADDR_ANY)
        s.setsockopt(socket.IPPROTO_IP, socket.IP_ADD_MEMBERSHIP, mreq)

        while True:
            # logger.debug("Collector阻塞接收数据...");
            data, addr = s.recvfrom(SysSettings.MULTICAST_BUF_SIZE)  # 接收数据 自动阻塞 等待客户端请求:
            # logger.debug("data:%s, addr:%s" % (data.decode(), addr));
            self.processData(data.decode())

            # s.sendto('Hello, 你好!'.encode(), addr);
            # recvfrom()方法返回数据和客户端的地址与端口，这样，服务器收到数据后，直接调用sendto()就可以把数据用UDP发给客户端。

    def processData(self, dataStr):
        """数据处理.
        :param dataStr:接收到中间件发送过来的UDP数据,字符串型
        """
        try:
            dataA = json.loads(dataStr)
            # logger.info("主动上报：%s" % dataStr)

            # 将msg中的数据封装成Event对象
            if dataA != None and len(dataA) > 0:
                data = dataA[0]
                typeEvt = data.get("type")
                evt = None

                if typeEvt == EvtType.BOX_STATUS.value:
                    evt = BoxEvent(EvtSender.MIDDLE, EvtType.BOX_STATUS, data.get("deviceId"), data.get("MAC", ""))
                elif typeEvt == EvtType.SLOT_STATUS.value:
                    evt = SlotEvent(EvtSender.MIDDLE, EvtType.SLOT_STATUS, data.get("deviceId"), data.get("slotId"),
                                    data.get('slotStatus'), data.get('cardType'), data.get("MAC", ""))
                elif typeEvt == EvtType.PRESET_POOL.value:
                    evt = PresetPoolEvent(EvtSender.MIDDLE, EvtType.PRESET_POOL, data.get('deviceId'),
                                          data.get('screenId'), data.get('presetId'), data.get('layoutTemplateId'), data.get("MAC", ""))
                elif typeEvt == EvtType.UPGRADE.value:
                    evt = UpgradeEvent(EvtSender.MIDDLE, EvtType.UPGRADE, data.get('deviceId'), data.get("MAC", ""))
                elif typeEvt == EvtType.SCREENBRIGHTNESS.value:
                    evt = ScreenBrightnessEvent(EvtSender.MIDDLE, EvtType.SCREENBRIGHTNESS, data.get('deviceId'),
                                                data.get('screenId'), data.get('brightness'), data.get('clientType'), data.get("MAC", ""))
                elif typeEvt == EvtType.SCREENHDR.value:
                    evt = ScreenHDREvent(EvtSender.MIDDLE, EvtType.SCREENHDR, data.get('deviceId'),
                                                data.get('screenId'), data.get("MAC", ""))
                elif typeEvt == EvtType.HDR_SUPPORT.value:
                    evt = HDRSupportEvent(EvtSender.MIDDLE, EvtType.HDR_SUPPORT, data.get('deviceId'),
                                          data.get("MAC", ""))
                elif typeEvt == EvtType.IPC_URL_STATUS.value:
                    evt = IPCUrlEvent(EvtSender.MIDDLE, EvtType.IPC_URL_STATUS, data.get('deviceId'),
                                      data.get('sourceId'), data.get('channelId'), data.get("MAC", ""))
                elif typeEvt == EvtType.STD_IO_Card_STATUS.value:
                    evt = STDIOCardEvent(EvtSender.MIDDLE, EvtType.STD_IO_Card_STATUS, data.get('deviceId'),
                                      data.get('slotId'), data.get("MAC", ""))
                elif typeEvt == EvtType.OUTPUT_BACKUP_STATUS.value:
                    evt = OutputBackupCardEvent(EvtSender.MIDDLE, EvtType.OUTPUT_BACKUP_STATUS, data.get('deviceId'),
                                      data.get('slotId'), data.get("MAC", ""))
                elif typeEvt == EvtType.LanguageMode.value:
                    evt = LanguageModeEvent(EvtSender.MIDDLE, EvtType.LanguageMode, data.get('deviceId'),
                                            data.get('lang'), data.get("MAC", ""))
                elif typeEvt == EvtType.IPCMontageStatus.value:
                    evt = IPCMontageEvent(EvtSender.MIDDLE, EvtType.IPCMontageStatus, data.get('deviceId'),
                                          data.get('slotId'), data.get('montageId'), data.get("MAC", ""))
                elif typeEvt == EvtType.ScreenAudioChanged.value:
                    evt = ScreenAudioEvent(EvtSender.MIDDLE, EvtType.ScreenAudioChanged, data.get('deviceId'),
                                          data.get('screenId'), data.get('inputId'), data.get("MAC", ""))
                elif typeEvt == EvtType.GenLockChanged.value:
                    evt = GenLockEvent(EvtSender.MIDDLE, EvtType.GenLockChanged, data.get('deviceId'),
                                           data.get("MAC", ""))
                elif typeEvt == EvtType.UpdateScreenOsd.value:
                    evt = PresetDataEvent(EvtSender.MIDDLE, EvtType.UpdateScreenOsd, data.get('deviceId'),
                                          data.get('screenId'), data.get('presetId'), data.get("MAC", ""))
                elif typeEvt == EvtType.FiberModeChanged.value:
                    evt = FiberModeChangedEvent(EvtSender.MIDDLE, EvtType.FiberModeChanged, data.get('deviceId'),
                                        data.get('inputId'), data.get("MAC", ""))
                elif typeEvt == EvtType.VideoStreamingChanged.value:
                    evt = VideoStreamEvent(EvtSender.MIDDLE, EvtType.VideoStreamingChanged, data.get('deviceId'),
                                           data.get('slotId'), data.get('slotStatus'), data.get("MAC", ""))
                elif typeEvt == EvtType.IPCOnLineChanged.value:
                    evt = IpcOnlineEvent(EvtSender.MIDDLE, EvtType.IPCOnLineChanged, data.get('deviceId'),
                                           data.get('sourceList'), data.get('groupId'), data.get("MAC", ""))
                elif typeEvt == EvtType.SourceDataChanged.value:
                    evt = SourceDataChangeEvent(EvtSender.MIDDLE, EvtType.SourceDataChanged, data.get('deviceId'),
                                         data.get('sourceType'), data.get('sourceId'),data.get('width'),data.get('height'), data.get("MAC", ""))
                elif typeEvt == EvtType.LedOsdChanged.value:
                    evt = ScreenLedOsdEvent(EvtSender.MIDDLE, EvtType.LedOsdChanged, data.get('deviceId'), data.get('screenId'),data.get("MAC", ""))
                elif typeEvt == EvtType.LedScreenShutDown.value:
                    evt = LedShutDownEvent(EvtSender.MIDDLE, EvtType.LedScreenShutDown, data.get('deviceId'), data.get("MAC", ""))
                elif typeEvt == EvtType.Led3DChanged.value:
                    evt = ScreenLed3dEvent(EvtSender.MIDDLE, EvtType.Led3DChanged, data.get('deviceId'), data.get('screenId'), data.get("MAC", ""))
                elif typeEvt == EvtType.OSDWeatherChanged.value:
                    evt = OSDWeatherEvent(EvtSender.MIDDLE, EvtType.OSDWeatherChanged, data.get('deviceId'),
                                          data.get('screenId'), data.get('osdId'), data.get("MAC", ""))
                elif typeEvt == EvtType.DeviceTimeChanged.value:
                    evt = DeviceTimeEvent(EvtSender.MIDDLE, EvtType.DeviceTimeChanged, data.get('deviceId'),
                                          data.get("MAC", ""))
                elif typeEvt == EvtType.MvrGroupPollStatus.value:
                    evt = MvrGroupPollStatusEvent(EvtSender.MIDDLE, EvtType.MvrGroupPollStatus, data.get('deviceId'), data.get("mvrGroupPollInputList"),
                                          data.get("MAC", ""))
                elif typeEvt == EvtType.LayerChanged.value:
                    evt = LayerChangedEvent(EvtSender.MIDDLE,EvtType.LayerChanged, data.get('deviceId'), data.get("MAC", ""), data.get('screenList'))
                elif typeEvt == EvtType.InputSourceChanged.value:
                    evt = InputSourceChangedEvent(EvtSender.MIDDLE, EvtType.InputSourceChanged, data.get('deviceId'),
                                           data.get('sourceId'), data.get('zorder'), data.get('useList'), data.get("MAC", ""))
                elif typeEvt == EvtType.InputSourceUsedChange.value:
                    evt = InputSourceUsedEvent(EvtSender.MIDDLE, EvtType.InputSourceUsedChange, data.get('deviceId'),
                                           data.get('sourceId'), data.get('isUsed'), data.get("MAC", ""))
                elif typeEvt == EvtType.InputSourceSubList.value:
                    evt = InputSubSourceListEvt(EvtSender.MIDDLE, EvtType.InputSourceSubList, data.get('deviceId'),
                                           data.get('sourceId'), data.get('subList'), data.get("MAC", ""))
                elif typeEvt == EvtType.NoTimeSourceDataChange.value:
                    evt = NoTimeSourceDataChangeEvt(EvtSender.MIDDLE, EvtType.NoTimeSourceDataChange, data.get('deviceId'),
                                                data.get('layer'), data.get("MAC", ""))
                else:
                    logger.error("上行-数据处理时-失败:事件类型在处理范围之外!type=%i" % typeEvt)
                # 将事件发送出去
                if evt != None:
                    sender.receive(evt)
            else:
                logger.error("上行-数据处理时-失败:数据为空!")
        except Exception:
            msg = traceback.format_exc()
            logger.error("上行-数据处理时-异常! exception.info:%s" % msg)
