"""
Created on 2021年9月07日
@author: 程声清
对应接口文档output.
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from flask import Blueprint, g
from flask.json import jsonify

from H_9U.api.output import output_read_all_list
from H_9U.api.screen import screen_list
from H_9U.api.websender import push_data
from H_9U.open.service import open_output_svc
from H_9U.util.common import get_params
from H_9U.util.logwrapper import open_log
from H_9U.models.result import get_result_model, ResInfo
from H_9U.models.syncdataname import SyncDataName

open_output_bp = Blueprint('open_output', __name__)


@open_output_bp.route('/readDetail', methods=['GET', 'POST'])
@open_log
def output_read_detail():
    """
    读取输出列表，简化字段
    :return: 参考文档 readDetail
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id = values
    rs = open_output_svc.output_read_detail(device_id, output_id)
    return jsonify((rs))


@open_output_bp.route('/readList', methods=['GET', 'POST'])
@open_log
def output_read_list():
    """
    读取输出列表，简化字段
    :return: 参考文档 readList
    """
    params = g.data
    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = open_output_svc.output_read_list(device_id)
    return jsonify((rs))


@open_output_bp.route('/rename', methods=['GET', 'POST'])
@open_log
def output_rename():
    """
    重命名
    :return: 参考文档writeGeneral
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId', 'name')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id, name = values
    rs = open_output_svc.output_rename(device_id, output_id, params)
    if rs['status'] == 0:
        push_data(output_read_all_list, SyncDataName.Output_Read_List, device_id)
    return jsonify((rs))


@open_output_bp.route('/writeTiming', methods=['GET', 'POST'])
@open_log
def output_write_timing():
    """
    设置timing
    :return:  参考文档writeTiming
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id = values
    output_list = [output_id]
    from H_9U.service.output import output_svc
    if 'outputIdList' not in params:
        params['outputIdList'] = [output_id]
    rs = output_svc.write_timing(device_id, output_list, params)
    if rs['status'] == 0:
        push_data(output_read_all_list, SyncDataName.Output_Read_List, device_id)
        push_data(screen_list, SyncDataName.Screen_Read_All_List, device_id)
        push_data(screen_list, SyncDataName.Output_Timing_Changed, device_id)
    return jsonify((rs))


@open_output_bp.route('/write4KTiming', methods=['GET', 'POST'])
def output_write_4k_timing():
    """
    设置指定输出的4KTiming信息
    :return: 结果对象
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id = values
    rs = open_output_svc.output_write_4k_timing(
        device_id, output_id, params)
    if rs['status'] == 0:
        push_data(output_read_all_list, SyncDataName.Output_Read_List, device_id)
        push_data(screen_list, SyncDataName.Screen_Read_All_List, device_id)
    return jsonify((rs))


@open_output_bp.route('/writePayload', methods=['GET', 'POST'])
def output_write_payload():
    """
    设置二合一卡带载面积
    :return: 结果对象
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id = values
    rs = open_output_svc.output_write_payload(
        device_id, output_id, params)
    if rs['status'] == 0:
        push_data(output_read_all_list, SyncDataName.Output_Read_List, device_id)
        push_data(screen_list, SyncDataName.Screen_Read_All_List, device_id)
    return jsonify((rs))


@open_output_bp.route('/writeImageQuality', methods=['GET', 'POST'])
@open_log
def output_image_quality_write():
    """
    设置画质
    :return:参考文档writeImageQuality
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id = values
    rs = open_output_svc.output_write_image_quality(
        device_id, output_id, params)
    if rs['status'] == 0:
        push_data(output_read_all_list, SyncDataName.Output_Read_List, device_id)
    return jsonify((rs))


@open_output_bp.route('/writeGamma', methods=['GET', 'POST'])
@open_log
def output_gamma_write():
    """
    设置Gamma
    :return:参考文档writeGamma
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id = values
    rs = open_output_svc.output_write_gamma(device_id, output_id, params)
    if rs['status'] == 0:
        push_data(output_read_all_list, SyncDataName.Output_Read_List, device_id)
    return jsonify((rs))


@open_output_bp.route('/writeFixedPosition', methods=['GET', 'POST'])
@open_log
def output_write_fixed_position():
    """
    读取最佳输出定位
    :return: 参考文档readFixedPosition
    """
    params = g.data
    values = get_params(params, 'deviceId')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id = values
    rs = open_output_svc.output_write_fixed_position(device_id, params)
    return jsonify((rs))


@open_output_bp.route('/writeResolution', methods=['GET', 'POST'])
@open_log
def output_write_resolution():
    """
   设置指定输出的Resolution信息
    :return: 结果对象
    """
    params = g.data
    values = get_params(params, 'deviceId', 'outputId', 'refreshRate', 'width', 'height')
    if values is None:
        return jsonify(get_result_model(ResInfo.Params_Error))
    device_id, output_id, refresh, width, height = values
    rs = open_output_svc.output_write_resolution(device_id, output_id, refresh, width, height)
    # 修改timing，推送输入源列表和屏幕列表
    if rs['status'] == 0:
        push_data(output_read_all_list, SyncDataName.Output_Read_List, device_id)
    return jsonify((rs))
