from H_9U.dao.open_user import openuserdao


def get_user_info(p_id):
    """
    根据pid获取该项目信息
    :param p_id: p_id
    :return: 项目信息
    """
    return openuserdao.get_user_info_by_p_id(p_id)


def get_user_info_by_key(p_key):
    """
    根据p_key获取该项目信息
    :param p_key: p_key
    :return: 项目信息
    """
    return openuserdao.get_user_info_by_key(p_key)


def get_user_info_by_name(project_name):
    """
      根据project_name获取该项目信息
      :param project_name: project_name
      :return: 项目信息
      """
    return openuserdao.get_user_info_by_name(project_name)


def add_user(data):
    """
    添加项目信息
    :param data: data
    :return:
    """
    return openuserdao.add_user_info(data)


def get_user_info_by_id(o_id):
    """
    根据id获取信息
    :param o_id: o_id
    :return:
    """
    return openuserdao.get_user_info_by_id(o_id)


def get_open_info_list():
    """
    获取信息
    :return:
    """
    return openuserdao.get_open_info_list()


def find_open_info_by_name(project_name):
    """
    根据projectName 模糊查询
    :param project_name: project_name
    :return:
    """
    return openuserdao.find_open_info_by_name(project_name)


def update_user_info_by_id(o_id, data):
    """
    根据id获取信息
    :param o_id: o_id
    :param data: data
    :return:
    """
    return openuserdao.update_user_info_by_id(o_id, data)


def delete_open_info(o_id):
    """
    删除与第三方信息
    :param o_id: o_id
    :return: 结果对象
    """
    return openuserdao.delete_open_info(o_id)
