"""
Created on 2021年9月14日
@author: 程声清
main服务类
"""
from flask import jsonify

from H_9U import controller
from H_9U.open.middle import open_device_middle, open_main_middle
from H_9U.models.result import get_result_model, ResInfo
from H_9U.conf.syssettings import SysSettings
from H_9U.models.sysconst import CardType


def main_init_status(device_id):
    """
    读取系统初始化状态
    :param device_id 设备号
    :return: 初始化状态和语言模式
    """
    status = controller.getInitStatus()
    # socket初始化成功
    if status:
        rs = get_result_model()
        rs['data']['initStatus'] = 1
        # 获取版本信息
        device_resp = open_device_middle.device_firware_version_read_middle(
            device_id)
        if device_resp['status'] == 0 and device_resp['data']:
            sn = device_resp['data']['mainControl']['sn']
        else:
            sn = ''
        # 处理主控id
        device_rs = open_device_middle.device_read_detail_middle(device_id)
        # slot_arr = []
        if device_rs['status'] == 0 and device_rs['data']:
            rs['data']['mainModelId'] = device_rs['data']['modelId']
        rs['data']['softwareVersion'] = SysSettings.SoftwareVersion
        rs['data']['sn'] = sn
        return rs
    else:
        return jsonify(get_result_model(ResInfo.Device_Is_Initing))


def main_read_video_server_info(device_id):
    """
    读取视频服务器地址业务处理
    ：param device_id :设备id
    :return:
    """
    mvr_url = SysSettings.MVR_URL
    echo_url = SysSettings.Echo_URL
    rs = _main_mvr_is_online(device_id)
    if rs['status'] == 0 and rs['data']:
        if rs['data']['online'] == 1:
            # 读取预监卡详细信息
            rs = open_device_middle.device_slot_read_middle(
                device_id, rs['data']['slotId'])
            if rs['status'] == 0 and rs['data']:
                # 读取encoding信息
                mvr_url = rs['data']['encoding']['mvrUrl']
                echo_url = rs['data']['encoding']['echoUrl']
    rs = open_main_middle.read_video_status_middle()
    video_status = 1
    if rs['status'] == 0 and rs['data']:
        video_status = rs['data']['videoStatus']

    rs = get_result_model()
    rs['data'] = {
        'mvrUrl': mvr_url,
        'echoUrl': echo_url,
        'videoStatus': video_status
    }
    return rs


def _main_mvr_is_online(device_id):
    """
    预监卡是否在线
    :param device_id:
    :return: 1 在线，0 不在线
    """
    rs = open_device_middle.device_read_detail_middle(device_id)
    on_line = 0
    slot_id = -1
    if rs['status'] == 0 and rs['data']:
        # 读取预监卡
        slots = [s for s in rs['data']['slotList']
                 if s['cardType'] == CardType.Mvr]
        if slots:
            # 预监卡接口是否有接口
            if slots[0]['cardType'] != 0:
                on_line = 1
                slot_id = slots[0]['slotId']
    rs = get_result_model()
    rs['data'] = {'online': on_line, 'deviceId': device_id, 'slotId': slot_id}
    return rs
