'''
Created on 2018年10月16日

@author: Administrator
'''
import binascii


# 10进制转16进制,且补充为双位.
def toHexDual(p):
    if p != None:
        rs = hex(p);
        rs = rs.replace("0x", "");
        rs = rs.upper();
        
        length = len(rs);
        mode = length % 2;
        
        if mode == 1:
            rs = "0" + rs;

        return rs;
    else:
        return None;

# 10进制转16进制,且补充为指定的字节数长度,高位补0.
def toHex(p, byteNum):
    rs = hex(p);
    rs = rs.replace("0x", "");
    rs = rs.upper();

    return remedyHexBit(rs, byteNum);

# 补充hex长度
# byteNum:字节数;data:待补充的数据;
def remedyHexBit(data, byteNum):
    length = len(data);
    shouldLen = byteNum * 2;
    
    addLen = shouldLen - length;
    
    while addLen > 0:
        data = "0" + data;
        addLen = addLen - 1;
    
    return data;


# 将int数值转换为占四个字节的byte数组，本方法适用于(低位在前，高位在后)的顺序。 和bytesToInt（）配套使用
def intToBytesLH4(value):
    src = [0]*4;
    
    src[3] = ((value>>24) & 0xFF);
    src[2] = ((value>>16) & 0xFF);
    src[1] = ((value>>8) & 0xFF);  
    src[0] = (value & 0xFF);

    return bytes(src);

# 将int数值转换为占两个字节的byte数组，本方法适用于(低位在前，高位在后)的顺序。 和bytesToInt（）配套使用
def intToBytesLH2(value):
    src = [0]*2;
    
    src[1] = ((value>>8) & 0xFF);  
    src[0] = (value & 0xFF);

    return bytes(src);

# 将int数值转换为占一个字节的byte数组，本方法适用于(低位在前，高位在后)的顺序。 和bytesToInt（）配套使用
def intToBytesLH1(value):
    src = [0]*1;
    
    src[0] = (value & 0xFF);

    return bytes(src);


# 将int数值转换为占四个字节的byte数组，本方法适用于(高位在前，低位在后)的顺序。  和bytesToInt2（）配套使用
def intToBytesHL4(value):
    src = [0]*4;
    
    src[0] = ((value>>24) & 0xFF);
    src[1] = ((value>>16) & 0xFF);
    src[2] = ((value>>8) & 0xFF);  
    src[3] = (value & 0xFF);

    return bytes(src);

# 将int数值转换为占两个字节的byte数组，本方法适用于(高位在前，低位在后)的顺序。  和bytesToInt2（）配套使用
def intToBytesHL2(value):
    src = [0]*2;
    
    src[0] = ((value>>8) & 0xFF);  
    src[1] = (value & 0xFF);
     
    return bytes(src);

# 将int数值转换为占一个字节的byte数组，本方法适用于(高位在前，低位在后)的顺序。  和bytesToInt2（）配套使用
def intToBytesHL1(value):
    src = [0]*1;
    
    src[0] = (value & 0xFF);

    return bytes(src);

# 将int数值转换为占四个字节的byte数组
# model:True-高位在前;False:地位在前.
def intToBytes4(value, model=True):
    if model:
        return intToBytesHL4(value);
    else:
        return intToBytesLH4(value);

# 将int数值转换为占两个字节的byte数组
# model:True-高位在前;False:地位在前.
def intToBytes2(value, model=True):
    if model:
        return intToBytesHL2(value);
    else:
        return intToBytesLH2(value);

# 将int数值转换为占一个字节的byte数组
# model:True-高位在前;False:地位在前.
def intToBytes1(value, model=True):
    if model:
        return intToBytesHL1(value);
    else:
        return intToBytesLH1(value);

def bytesToIntLH4(src, offset):
    value = (src[offset] & 0xFF) | ((src[offset+1] & 0xFF)<<8) | ((src[offset+2] & 0xFF)<<16) | ((src[offset+3] & 0xFF)<<24);
    
    return value;

def bytesToIntLH2(src, offset):
    value = (src[offset] & 0xFF) | ((src[offset+1] & 0xFF)<<8);

    return value;

def bytesToIntLH1(src, offset):
    value = (src[offset] & 0xFF);
    
    return value;

def bytesToIntHL4(src, offset):
    value = ((src[offset] & 0xFF)<<24) | ((src[offset+1] & 0xFF)<<16) | ((src[offset+2] & 0xFF)<<8) | (src[offset+3] & 0xFF);
    
    return value;

def bytesToIntHL2(src, offset):
    value = ((src[offset] & 0xFF)<<24) | ((src[offset+1] & 0xFF)<<16);

    return value;

def bytesToIntHL1(src, offset):
    value = ((src[offset] & 0xFF)<<24);
    
    return value;

if __name__ == '__main__':
    rs1 = intToBytes2(0x55AA);
    rs2 = intToBytes2(0x0010);
    rs3 = intToBytes2(0x0101);

    rs = rs1 + rs2 + rs3;
    


    # 字节串转16进制表示,夹带ascii

    # 字节码解码为字符串
    msg = "12345gqb宫庆宝";
    ba = bytes(msg, encoding="utf8");
    print(bytes.decode(ba, encoding="utf8"));
    print(str(ba, encoding="utf8"));
    print("msg.len:%i, ba.len:%i" % (len(msg), len(ba)));

    # 字节串转16进制表示,固定两个字符表示
    print(str(binascii.b2a_hex(rs))[2:-1]);
    
    # 字节串转16进制数组
    print([hex(x) for x in bytes(rs)]);
    
    # 将list转成str
    lst = ['Michael','Jack','Bob','Tracy','Adam'];
    lstStr = "".join(lst);
    print(lstStr);
    
