#!/usr/bin/python
import socket
from time import sleep
import time
import json

MULTICAST_ADDRESS = "235.235.235.236"
MULTICAST_PORT = 7777
MULTICAST_TTL = 4
MULTICAST_COUNT = 10
MULTICAST_SEND_RATE = 100
MULTICAST_PAYLOAD = {"deviceId": 0, "type": 1, "slotId": 1, "MAC": "7e-ef-1c-b0-14-4a"}
# MULTICAST_PAYLOAD = {"deviceId":0,"type":10,"slotId":1,"slotStatus":1,"MAC":"be-22-1b-a6-5d-b9"} # {"deviceId": 0, "type": 8, "slotId": 1, "screenId": 0,"presetId": 1, "MAC": '00-11-22-33-44-55'}

s = time.time()
rateS = 1 / float(MULTICAST_SEND_RATE)
print("Sending " + str(MULTICAST_COUNT) + " UDP segments to " + str(MULTICAST_ADDRESS) + ":" + str(
    MULTICAST_PORT) + " every " + str(rateS) + "s")

# create socket
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM, socket.IPPROTO_UDP)
sock.setsockopt(socket.IPPROTO_IP, socket.IP_MULTICAST_TTL, MULTICAST_TTL)

# send and wait
for x in range(MULTICAST_COUNT):
    MULTICAST_PAYLOAD['slotId'] = x
    sock.sendto(json.dumps([MULTICAST_PAYLOAD]).encode(), (MULTICAST_ADDRESS, MULTICAST_PORT))
    sleep(rateS)

# for x in range(MULTICAST_COUNT):
#     for i in range(21):
#         MULTICAST_PAYLOAD['slotId'] = i
#         print(MULTICAST_PAYLOAD)
#         sock.sendto(json.dumps([MULTICAST_PAYLOAD]).encode(), (MULTICAST_ADDRESS, MULTICAST_PORT))
#         sleep(rateS)
