"""
Created on 2021年9月06日
@author: 程声清
对请求加密以及解密处理
"""
import base64
import json
import uuid

from H_9U.util.pyDes import des, PAD_PKCS5, ECB
from H_9U.util.common import md5

# DES 加密


def des_encrypt(s, key):
    """
    DES 加密
    :param s: 字符串
    :param key: 解密的密钥
    :return:  加密后的字符串
    """
    s1 = json.dumps(s, indent=2)
    secret_key = key
    iv = secret_key
    k = des(secret_key, ECB, iv, pad=None, padmode=PAD_PKCS5)
    en = k.encrypt(s1, padmode=PAD_PKCS5)
    return base64.b64encode(en).decode('ascii')


# DES 解密
def des_decrypt(s, key):
    """
    DES 解密
    :param s: 加密后的字符串
    :param key: 解密的密钥
    :return:  解密后的字符串
    """
    secret_key = key
    iv = secret_key
    k = des(secret_key, ECB, iv, pad=None, padmode=PAD_PKCS5)
    de = k.decrypt(base64.b64decode(s), padmode=PAD_PKCS5)
    return de.decode('utf-8')


# 请求参数的sign 加密
def signature_encrypt(s, timestamp, p_id, key):
    """
    sign 加密
    :param s: body密文
    :param timestamp: 时间戳
    :param p_id: p_id
    :param key: 加密的密钥
    :return:  加密后的字符串
    """
    str1 = s + timestamp + p_id + key
    en = md5(str1).encode('utf-8')
    return base64.b64encode(en).decode('ascii')


# 请求参数的sign 不加密时对 sign加密
def signature_encrypt_sign(timestamp, p_id):
    """
    sign 加密
    :param timestamp: 时间戳
    :param p_id: p_id
    :return:  加密后的字符串
    """
    str1 = timestamp + p_id
    en = md5(str1).encode('utf-8')
    return base64.b64encode(en).decode('ascii')


# 响应参数的sign加密
def signature_encrypt_res(s, p_id, key):
    """
    sign 加密
    :param s: body密文
    :param p_id: p_id
    :param key: 加密的密钥
    :return:  加密后的字符串
    """
    str1 = s + p_id + key
    en = md5(str1).encode('utf-8')
    return base64.b64encode(en).decode('ascii')


def get_pid():
    """
    随机获取pId
    :return:  加密的pId
    """
    uid = str(uuid.uuid4())
    suid = ''.join(uid.split('-'))[0:4]
    en = md5(suid).encode('utf-8')
    return base64.b64encode(en).decode('ascii')[0:4]


def get_secret_key():
    """
    随机获取秘钥
    :return:  加密的密钥
    """
    uid = str(uuid.uuid4())
    suid = ''.join(uid.split('-'))[4:9]
    en = md5(suid).encode('utf-8')
    return base64.b64encode(en).decode('ascii')[0:8]


def param_isinstance(body_, sign, time_stamp, number):
    """
    参数校验 加密参数必须传str 不加密传dict
    :param body_: body
    :param sign: sign
    :param time_stamp: time_stamp
    :param number: 是否加密的标识
    :return:
    """
    is_correct = False
    if number == 1:
        if isinstance(body_, str):
            is_correct = True
            return is_correct
    if number == 0:
        if isinstance(body_, dict):
            is_correct = True
        return is_correct
    if number == 2:
        if isinstance(sign, str):
            is_correct = True
            return is_correct
        if isinstance(time_stamp, str):
            is_correct = True
            return is_correct
        if isinstance(body_, str):
            is_correct = True
            return is_correct
    return is_correct
