#!/bin/sh

if [ -f /usr/Hseries/bin/log.sh ]; then
	. /usr/Hseries/bin/log.sh
else 
	log_info()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_debug()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_error()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

if [ -f /usr/Hseries/bin/setmode.sh ]; then
	. /usr/Hseries/bin/setmode.sh
else 
	setmode()
	{
		echo "setmode do nothing" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

log_info "Hseries-daemon.sh start"

start_Middleware()
{
	#run MasterProcess
	device_type=`cat /proc/chassis_info/model_id`
	if [ $device_type = "2" ]; then
		#reset crosspoint chip
		echo "14" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 12 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_5U -r &
			log_info "run MasterProcess_Alita_5U"
			cp MasterProcess_Alita_5U  ./coreDump
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H5 -r &
			log_info "run MasterProcess_H5"
			cp MasterProcess_H5  ./coreDump
		fi
	elif [ $device_type = "3" ]; then
		#reset crosspoint chip
		echo "21" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 22 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1
		cd /usr/Hseries/bin/Middleware && ./MasterProcess_H9_10X5 -r &
		log_info "run MasterProcess_H9_10X5"
		cp MasterProcess_H9_10X5 ./coreDump
	elif [ $device_type = "4" ]; then
		#reset crosspoint chip
		echo "21" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 22 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_2U -r &
			log_info "run MasterProcess_Alita_2U"
			cp MasterProcess_Alita_2U ./coreDump
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H2 -r &
			log_info "run MasterProcess_H2"
			cp MasterProcess_H2 ./coreDump
		fi
	elif [ $device_type = "5" ]; then
		#reset crosspoint chip
		echo 0 > /sys/class/gpio/gpio1200/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1200/value
		#aux UART
		echo 1 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_15U -r &
			log_info "run MasterProcess_Alita_15U"
			cp MasterProcess_Alita_15U ./coreDump
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H15 -r &
			log_info "run MasterProcess_H15"
			cp MasterProcess_H15 ./coreDump
		fi
		
	elif [ $device_type = "6" ]; then
		#reset crosspoint chip
		echo 0 > /sys/class/gpio/gpio1200/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1200/value
		#aux UART
		echo 1 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1
		cd /usr/Hseries/bin/Middleware && ./MasterProcess_H15_Pro -r &
		log_info "run MasterProcess_H15_Pro"
		cp MasterProcess_H15_Pro ./coreDump
	elif [ $device_type = "7" ]; then
		#reset crosspoint chip	GPIO6_C0
		echo 0 > /sys/class/gpio/gpio1200/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1200/value
		#reset crosspoint chip2  GPIO2_A5_d
		echo 0 > /sys/class/gpio/gpio1061/value
		sleep 0.5
		echo 1 > /sys/class/gpio/gpio1061/value

		#aux UART
		echo 1 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_20U -r &
			log_info "run MasterProcess_Alita_20U"
			cp MasterProcess_Alita_20U  ./coreDump
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H20U -r &
			log_info "run MasterProcess_H20"
			cp MasterProcess_H20U ./coreDump
		fi
	else
		#reset crosspoint chip
		echo "21" "1" > /sys/devices/platform/multi_iocfg.0/multi_iocfg/reset
		#aux UART
		echo 22 > /sys/devices/platform/uart_com.0/uart_com/uart_chl_sel
		sleep 1

		if [ -f "/usr/Hseries/bin/Middleware/alita_series" ]; then
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_Alita_9U -r &
			log_info "run MasterProcess_Alita_9U"
			cp MasterProcess_Alita_9U ./coreDump
		else
			cd /usr/Hseries/bin/Middleware && ./MasterProcess_H9 -r &
			log_info "run MasterProcess_H9"
			cp MasterProcess_H9 ./coreDump
		fi
	fi
}

start_middleware_daemon()
{
	ethmode=`/usr/nova/bin/sysconfig get ethmode_eth1`

	if [ $ethmode -eq 1 ];then   #dhcp
		killall -9 dhclient
		start_Middleware
		/usr/Hseries/bin/Hseries_env.sh && set_dhcp eth1
	else	
		killall -9 dhclient
		start_Middleware
	fi
}

start_GUI()
{
	device_type=`cat /proc/chassis_info/model_id`
	log_info "start GUI, device type=${device_type}"
	if [ $device_type = "4" ]; then
		cd /usr/Hseries/bin/GUI && ./H9U_GUI -platform linuxfb:fb=/dev/fb1&
	else
		cd /usr/Hseries/bin/GUI && ./H9U_GUI &
	fi
}
 
#daemon sh
start_daemon()
{
	ttime=`date +"%Y-%m-%d %H:%M:%S"`
	echo -n $ttime >> /usr/Hseries/bin/daemon.log
	echo ":begin daemon~~~~~~~~~~~~~~~~~" >> /usr/Hseries/bin/daemon.log
	log_info "start_daemon start"
	while [ true ]
	do
		sn=`ps -ef | grep MasterProcess | grep -v grep |awk '{print $2}'`
		#echo $sn
		if [ "${sn}" = "" ]    #���Ϊ��,��ʾ����δ����
		then

			if [ -d "/usr/Hseries/bin/Middleware/coreDump" ]; then		
				cd /usr/Hseries/bin/Middleware && rm coreDump -rf && mkdir coreDump
			else
				cd /usr/Hseries/bin/Middleware && mkdir coreDump
			fi		
			mv  /usr/Hseries/bin/Middleware/core  /usr/Hseries/bin/Middleware/coreDump
			
			#start_Middleware #��̨��������
			start_middleware_daemon
			
			ttime=`date +"%Y-%m-%d %H:%M:%S"`
      		echo -n $ttime >> /usr/Hseries/bin/daemon.log
			echo ":start MasterProcess ok !" >> /usr/Hseries/bin/daemon.log
		fi

		sn=`ps -ef | grep Xorg | grep -v grep |awk '{print $2}'`
		if [ "${sn}" = "" ]    #���Ϊ��,��ʾ����δ����
		then
			/usr/bin/Xorg & #��̨����X11����
			#/usr/lib/xorg/Xorg :0 -seat seat0 -auth /home/linaro/.Xauthority -nolisten tcp vt7 -novtswitch &
			
			ttime=`date +"%Y-%m-%d %H:%M:%S"`
			echo -n $ttime >> /usr/Hseries/bin/daemon.log
			echo ":start Xorg ok !" >> /usr/Hseries/bin/daemon.log
			
			log_info "start_daemon start Xorg"
			
			setmode
			killall H9U_GUI
			sleep 1
		fi
		
		sn=`ps -ef | grep H9U_GUI | grep -v grep |awk '{print $2}'`
		#echo $sn
		if [ "${sn}" = "" ]    #���Ϊ��,��ʾ����δ����
		then
			start_GUI
			ttime=`date +"%Y-%m-%d %H:%M:%S"`
			echo -n $ttime >> /usr/Hseries/bin/daemon.log
			echo ":start GUI ok !" >> /usr/Hseries/bin/daemon.log
			log_info "start_daemon start GUI"
		fi
		
		sleep 3
	done
}



cd /usr/Hseries/bin && sh start_video.sh &
start_daemon