#!/bin/sh

set_dhcp()
{
	if [ $# -ne 1 ];then
		echo '请指定网络接口名'
		return
	fi
	eth=$1
	/usr/nova/bin/sysconfig set ethmode_$eth 1
	killall -9 dhclient
	ip addr flush dev $eth
	dhclient -i $eth
	ipaddr=`ifconfig $eth|grep "inet"|grep -v "inet6" | awk '{print $2}'`
	netmask=`ifconfig $eth|grep "inet"|grep -v "inet6" | awk '{print $4}'`
	if [ ! $ipaddr ];then
		ipaddr=192.168.0.10
		gateway=192.168.0.1
	fi
	if [ ! $netmask ];then
		netmask=255.255.255.0
	fi
	/usr/nova/bin/sysconfig set ipaddr_$eth $ipaddr
	/usr/nova/bin/sysconfig set  netmask_$eth $netmask
	ifconfig $eth $ipaddr netmask $netmask
	if [ $gateway ];then
		ip route add default via 192.168.0.1
        /usr/nova/bin/sysconfig set gateway_$eth $gateway
	fi
}
