#!/bin/sh

if [ -f /usr/Hseries/bin/log.sh ]; then
	. /usr/Hseries/bin/log.sh
else 
	log_info()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_debug()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
	log_error()
	{
		echo "$@" >> /usr/Hseries/bin/Middleware/log/shell.log
	}
fi

setmode()
{
	log_info "setmode"
	log_info "set backlight/brightness off"
	echo 0 > /sys/class/backlight/backlight/brightness
	max_x=`cat /sys/module/goodix_gt9xx/parameters/max_x`
	max_y=`cat /sys/module/goodix_gt9xx/parameters/max_y`
	echo max_x=$max_x>>/root/sc.log
	echo max_y=$max_y>>/root/sc.log
	echo `id` >> /root/sc.log
	resolution="null"
	
	sn=`ps -ef | grep Xorg | grep -v grep |awk '{print $2}'`
	log_info "Xorg pid=${sn}"
	if [ "${sn}" = "" ]; then #如果为空,表示进程未启动
		if [ ! -f "/etc/X11/xorg.conf.d/10-monitor.conf" ]; then
			echo "Section \"ServerFlags\"\n\tOption \"StandbyTime\" \"0\"\n\tOption \"SuspendTime\" \"0\"\n\tOption \"OffTime\" \"0\"\n\tOption \"BlankTime\" \"0\"\nEndSection\n\nSection \"Extensions\"\n\tOption \"DPMS\" \"Disable\"\nEndSection" > /etc/X11/xorg.conf.d/10-monitor.conf
		fi
		/usr/bin/Xorg & #后台启动X11服务
		log_info "Xorg not running, start Xorg"
		sleep 3
	fi
	
	log_info "XAUTHORITY=${XAUTHORITY}"
	log_info "DISPLAY=${DISPLAY}"
	if [ "$DISPLAY" = "" ]; then
		xhost +local:
	fi
	log_info "$(xauth list)"
	log_info "before lcd config"
	log_info "$(xrandr 2>&1)"

	if [ $max_x = 1280 -a $max_y = 800 ];then
		resolution="1280x800p60"
		#XAUTHORITY=/home/linaro/.Xauthority DISPLAY=:0.0 xrandr -s 1280x800p60 >> /root/sc.log 2>&1
		result = $(xrandr -s 1280x800p60 2>&1)
		log_info "${result}"	
	else
		resolution="1024x600p60"
		#XAUTHORITY=/home/linaro/.Xauthority DISPLAY=:0.0 xrandr -s 1024x600p60 >> /root/sc.log 2>&1
		result = $(xrandr -s 1024x600p60 2>&1)
		log_info "${result}"
	fi
	log_info "max_x=${max_x}, max_y=${max_y}, resolution=${resolution}"	
	log_info "after lcd config"
	log_info "$(xrandr 2>&1)"
	echo "automode $(date +%M:%S.%N)" >> /root/sc.log
	#printenv > /root/sc.log
}
