"""
Created on 2023年2月2日
@author: 程声清
input_filter
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
from H_9U.models.sysconst import UserRoleType
from flask import g


def _filter_input_func(role_type, role_data, data):
    """
    推送数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    slot_ids = [x['inputId'] for x in role_data]
    input_data_list = []
    if data:
        for input_data in data:
            slot_id = input_data['slotId']
            if slot_id in slot_ids:
                input_data_list.append(input_data)
    return input_data_list


def _filter_ipc_func(role_type, role_data, data):
    """
    推送数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    slot_ids = [x['inputId'] for x in role_data]
    ipc_data_list = []
    if data:
        for ipc_data in data['slotList']:
            slot_id = ipc_data['slotId']
            if slot_id in slot_ids:
                ipc_data_list.append(ipc_data)
        data['slotList'] = ipc_data_list
    return data

def _filter_ipc_montage_func(role_type, role_data, data):
    """
    推送数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    slot_ids = [x['inputId'] for x in role_data]
    ipc_data_list = []
    if data:
        for ipc_data in data['ipcMontageGroupList']:
            slot_id = ipc_data['slotId']
            if slot_id in slot_ids:
                ipc_data_list.append(ipc_data)
        data['slotList'] = ipc_data_list
    return data


def _filter_input_group_func(role_type, role_data, data):
    """
    推送数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    if data:
        if data['inputGroupList']:
            # 获取当前有权限的输入的槽位号
            slot_ids = [x['inputId'] for x in role_data]
            input_group_list_rs = data['inputGroupList']
            for index_a in range(len(input_group_list_rs) - 1, -1, -1):
                group_data = input_group_list_rs[index_a]
                # 获取当前分组列表中的所有输入源的Id
                if group_data['inputs']:
                    for index_c in range(len(group_data['inputs']) - 1, -1, -1):
                        des = group_data['inputs'][index_c]
                        input_id = des['inputId']
                        from H_9U.service.input import input_svc
                        detail_rs = input_svc.read_detail_by_input_id(
                                input_id)
                        if detail_rs['status'] == 0 and detail_rs['data']:
                            detail_slot_id = detail_rs['data']['slotId']
                            if detail_slot_id not in slot_ids:
                                group_data['inputs'].remove(des)
            return data
        else:
            data['inputGroupList'] = []
    return data


def _filter_input_group_list_func(role_type, role_data, data):
    """
    推送数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    slot_ids = [x['inputId'] for x in role_data]
    input_id = role_data['data']['inputId']
    from H_9U import app
    with app.app_context():
        g.token = "server_token"
        from H_9U.service.input import input_svc
        detail_rs = input_svc.read_detail_by_input_id(input_id)
        if detail_rs['status'] == 0 and detail_rs['data']:
            detail_slot_id = detail_rs['data']['slotId']
            if detail_slot_id not in slot_ids:
                data = None
        else:
            data = None
        return data


def _filter_input_group_push_func(role_type, role_data, data):
    """
    推送数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    slot_ids = [x['inputId'] for x in role_data]
    inputs = data['inputs']
    if inputs:
        for index in range(len(inputs) - 1, -1, -1):
            des = inputs[index]
            input_id = des['inputId']
            from H_9U import app
            with app.app_context():
                g.token = "server_token"
                from H_9U.service.input import input_svc
                detail_rs = input_svc.read_detail_by_input_id(
                        input_id)
                if detail_rs['status'] == 0 and detail_rs['data']:
                    detail_slot_id = detail_rs['data']['slotId']
                    if detail_slot_id not in slot_ids:
                        inputs.remove(des)
        data['inputs'] = inputs
    else:
        data['inputs'] = None
    return data
