"""
Created on 2023年2月2日
@author: 程声清
output_filter
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""

from H_9U.models.sysconst import UserRoleType


def _filter_output_func(role_type, role_data, data):
    """
    数据过滤
    :param role_type: role_type
    :param role_data: role_data
    :param data: data
    :return: 数据
    """
    if role_type == UserRoleType.Admin_Role:
        return data
    slot_ids = [x['outputId'] for x in role_data]
    output_list = []
    if data:
        for output in data:
            slot_id = output['slotId']
            if slot_id in slot_ids:
                output_list.append(output)
    return output_list
