import threading
import time
import json
import socket

from H_9U.util.log import logger
from H_9U.util.common import get_ip_ifconfig
from H_9U.conf.syssettings import SysSettings
from H_9U.api.device import read_fireware_version, read_ip
from H_9U.api.main import init_status
from H_9U.models.sysconst import DeviceType

sn = None


def _get_device_info():
    """
    获取mac地址
    :param device_id: 设备Id
    :return: mac地址
    """
    sn = ''
    model_id = ''
    is_success = False
    ip = None
    try:
        from H_9U import app
        from flask import g
        with app.app_context():
            g.token = 'updtoken'
            device = read_fireware_version(SysSettings.Device_Id)
            if device['status'] == 0:
                sn = device['data']['mainControl']['sn']
                model_id = device['data']['mainControl']['modelId']
                is_success = True
            ip_rs = read_ip(SysSettings.Device_Id)
            if ip_rs['status'] == 0 and ip_rs['data']:
                ip = '{}.{}.{}.{}'.format(ip_rs['data']['ip']['ip0'],
                                          ip_rs['data']['ip']['ip1'],
                                          ip_rs['data']['ip']['ip2'],
                                          ip_rs['data']['ip']['ip3'])
    except Exception as e:
        logger.error("UDP 广播 获取设备信息异常")
        logger.exception(e)
    return is_success, sn, model_id, ip


class UdpMonitorThread(threading.Thread):
    def __init__(self):
        super(UdpMonitorThread, self).__init__()

    def run(self):
        logger.info('Start UDP thread...')

        while True:
            s = None
            try:
                s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
                s.bind(('0.0.0.0', SysSettings.UDP_DEVICE_DETECT_PORT))

                while True:
                    data, address = s.recvfrom(1024)
                    rec_data = data.decode('utf-8')
                    rec_address = str(address)
                    logger.info('UDP 广播 接收数据：rec:%s from %s' % (rec_data, rec_address))
                    if rec_data:
                        resp = self.make_udp_response2(rec_data)
                        if resp:
                            response = json.dumps(resp, ensure_ascii=False)
                            logger.info('UDP 广播 响应数据：%s' % response)
                            s.sendto(response.encode(), address)
                        else:
                            s.sendto("".encode(), address)
                    # if rec_data == 'HSeries':
                    #     response = self.make_udp_response()
                    #     logger.info('UDP 广播 响应数据：%s' % response)
                    #     s.sendto(response.encode(), address)
            except Exception as e:
                logger.error("upd服务异常：%s" % e)
                if s:
                    s.close()

            time.sleep(1)

    # def make_udp_response(self):
    #     is_ready = False
    #     sn = ''
    #     model_id = ''
    #     ip = None
    #
    #     status = False
    #     try:
    #         from H_9U import app
    #         from flask import g
    #         with app.app_context():
    #             g.token = 'updtoken'
    #             status = init_status()
    #
    #     except Exception as e:
    #         logger.error("UDP 广播 获取设备信息异常")
    #         logger.exception(e)
    #
    #     if status:
    #         is_ready, sn, model_id, ip = _get_device_info()
    #
    #     if not ip:
    #         ip = get_ip_ifconfig()
    #     data = {'ip': ip,
    #             'status': 1 if is_ready else 0,
    #             'data': {
    #                 'modeId': model_id,
    #                 'sn': sn
    #             }}
    #     return json.dumps(data, ensure_ascii=False)


    def make_udp_response2(self, recv):
        status = False
        try:
            from H_9U import app
            from flask import g
            with app.app_context():
                g.token = 'updtoken'
                status = init_status()

        except Exception as e:
            logger.error("UDP 广播 获取设备信息异常")
            logger.exception(e)
            return None

        if not status:
            if not status:
                _, _, model_id, _ = _get_device_info()
                if model_id in DeviceType.P_Main_All:
                    return {
                        'ip': '',
                        'status': 0,
                        'version': SysSettings.SoftwareVersion,
                        'data': {
                            'modeId': '',
                            'sn': '',
                            'versionType': SysSettings.Version_Type,
                            'version': SysSettings.SoftwareVersion,
                        }}
                else:
                    return {
                        'ip': '',
                        'status': 0,
                        'version': SysSettings.SoftwareVersion,
                        'data': {
                            'modeId': '',
                            'sn': ''
                        }}
        data = self.get_resp_data()

        if data['data']['modelId'] in DeviceType.Alita_ALL:
            try:
                search_info = json.loads(recv)
            except:
                return None
            if search_info:
                return self.search_info_filter(search_info, data)
        else:
            if recv == 'HSeries':
                return data


    def search_info_filter(self, recv, resp):
        if resp['status'] == 0:
            return None
        model_id = resp['data']['modelId']
        if 'searchInfo' in recv:
            if recv['searchInfo'] and model_id not in [x['modelId'] for x in recv['searchInfo']]:
                return None
            return resp
        elif 'splicer' in recv:
            if not recv['splicer']:
                return resp
            if 'modelIdList' in recv['splicer'] and model_id in [x['modelId'] for x in recv['splicer']['modelIdList']]:
                return resp

            key = 'hs'
            if resp['data']['modelId'] in DeviceType.Alita_ALL:
                key = 'al'

            if key not in recv['splicer']:
                return None
            if recv['splicer'][key] and model_id not in [x['modelId'] for x in recv['splicer'][key]]:
                return None
            return resp


    def get_resp_data(self):
        is_ready, sn, model_id, ip = _get_device_info()
        if not ip:
            ip = get_ip_ifconfig()
        return {'ip': ip,
                'version': SysSettings.SoftwareVersion,
                'status': 1 if is_ready else 0,
                'data': {
                    'modelId': model_id,
                    'sn': sn
                }}
