'''
Created on 2019年8月6日
@author: GongQingBao
通讯器：使用'pipe/管道'、'parser/解析器'完成数据的读写.
另外,统计了读写数据所耗用的时间.
'''

import threading
import time
import traceback

from H_9U.conf.syssettings import SysSettings
from H_9U.protocol.fncode import FnCode
from H_9U.protocol.radix import toHexDual
from H_9U.protocol.resUtil import getRsList
from H_9U.protocol.responseSatus import ResponseStatus
from H_9U.protocol.statisticTime import calUsedTime
from H_9U.util.log import logger


class Communicator(object):


    def __init__(self, name, pipe, parser):
        """构造函数
        :param name:通讯器名称[不参与业务处理]
        :param pipe:数据管道,与底层进行数据交互的管道
        :param parser:协议解析器
        """
        logger.info("%s Communicator初始化 开始" % str(name))
        self.name = name
        self.pipe = pipe
        self.parser = parser
        self.lastSessionId = None # 最后访问者的回话ID
        self.lastAccesTime = None # 最后访问时间(1970纪元后经过的浮点秒数)
        self.lastOptType = None  # 操作类型[0-读|1-写]
        self.busying = False     # 是否忙碌中[True-是|Flase-否]

        self.threadLock = threading.Lock() # 线程同步锁
        self.calComUsedTime = SysSettings.CalCommunicationUsedTime # 是否计算通讯耗时（0:不计算;1:计算）

        self.heartbeatCycleTime = 15 # 心跳周期
        self.heart_beat = threading.Thread(target=self.sendHeartbeat)
        self.heart_beat.start()

        logger.info("%s Communicator初始化 完成" % str(name));


    def startTimer(self):
        """心跳Timer.
        """
        self.timer = threading.Timer(self.heartbeatCycleTime, self.sendHeartbeat);
        self.timer.start();


#     def sendHeartbeat(self):
#         """发送心跳包.
#         """
#         if self.pipe.linked and self.isToSendTime():
#             rs = self.sendReceiveData(FnCode.DEVICE_HEARTBEAT, 1, [{}], True, 0);
# 
#             if rs != None and rs["status"] == 0:
#                 logger.debug("心跳-成功!CODE:%i,name:%s" % (rs["status"], str(self.name)));
#             else:
#                 logger.error("心跳-失败!CODE:%i" % rs["status"]);
#         else:
#             logger.info("心跳-不具备发送条件! linked:%s, isToSendTime:%s" % (self.pipe.linked, self.isToSendTime()));
# 
#         self.startTimer();


    def sendHeartbeat(self):
        """发送心跳包.
        """
        while True:
            if self.isToSendTime():
                rs = self.sendReceiveData(FnCode.DEVICE_HEARTBEAT, 1, [{}], True, 0)

                if rs != None and rs["status"] == 0:
                    logger.debug("心跳-成功!CODE:%i,name:%s" % (rs["status"], str(self.name)))
                else:
                    logger.error("心跳-失败!CODE:%i" % rs["status"])
                    if self.pipe != None:
                        logger.error("心跳-失败!进入重连")
                        self.pipe.linkToServer(self.pipe.ip, self.pipe.port)
                    else:
                        logger.error("心跳-失败!pipe为空，不能进入重连")
            else:
                logger.info("心跳-不具备发送条件:时间未到! isToSendTime:%s" % (self.isToSendTime()))
            time.sleep(self.heartbeatCycleTime)

    
    def isToSendTime(self):
        """判断是否到了心跳发送时间.
        :return: True-是否;False-否.
        """
        if self.lastAccesTime == None:
            return True
        else:
            if (time.monotonic() - self.lastAccesTime) >= self.heartbeatCycleTime:
                return True
            else:
                return False


    def setTimeout(self, timeoutValue):
        """设置通讯器的超时时间
        :param timeoutValue:通讯超时时间,单位：秒
        """
        self.pipe.setTimeout(timeoutValue)


    def sendReceiveData(self, fnCode, rwCode, data, needRs, reSendNum, *params):
        """发送并接收中间件相应的数据
        :param fnCode:功能码
        :param rwCode:操作类型[0-读|1-写]
        :param data:待发送的json对象或数组[可为空None]
        :param needRs:是否需要终端的返回值[True-需要|False-不需要],不需要时返回值中status=0
        :param reSendNum:重发次数
        :param params:可变参数
        :return: {msg:"",status:0,data:jsonArray}
            msg:消息文本;
            status:传输状态;
            data:json对象数组
        """
        self.threadLock.acquire() # 同步：如果'上次通讯未完成则需进行等待'
        rs = getRsList()
        
        try:
            byteA = self.parser.packageSendData(fnCode, rwCode, data, *params); # 打包要发送的数据
            st = time.monotonic() # 返回当前时间的时间戳（1970纪元后经过的浮点秒数）
#             print("fnCode:%s,发送" % toHexDual(fnCode))
            sendCode = self.pipe.sendData(byteA, reSendNum) # 向终端发送消息

            # 发送成功后才有必要再接收数据
            if sendCode == 0:
                if needRs:
#                     print("fnCode:%s,等待接收" % toHexDual(fnCode))
                    revCode,buf = self.pipe.receiveData() # 阻塞接收数据
    
                    if revCode == 0:
                        isGoon, revData, transmit, errCode = self.parser.parse(buf, None, None) # 解析数据
    
                        if errCode == 0:
                            while isGoon and errCode == 0:
                                buf = None
                                revCode,buf = self.pipe.receiveData() # 阻塞接收数据
    
                                if revCode == 0:
                                    isGoon, revData, transmit, errCode = self.parser.parse(buf, revData, transmit) # 解析数据
                                    if errCode != 0:
                                        rs["status"] = revCode
                                else:
                                    rs["status"] = revCode
                                    break
                        else:
                            rs["status"] = errCode
                            logger.error("解析数据时-CODE非0!errCode:%i,fnCode:%s,rwCode:%i,sendData:%s,recData:%s" % (errCode, toHexDual(fnCode), rwCode, data, buf))
    
                        rs["data"] = revData # 接收到的最后、完整数据
                    else:
                        rs["status"] = revCode
                        logger.error("通讯-接收数据-失败! fnCode:%s, revCode:%i" % (toHexDual(fnCode), revCode))
            else:
                rs["status"] = sendCode;
                logger.error("通讯-发送数据-失败! fnCode:%s, sendCode:%i" % (toHexDual(fnCode), sendCode))
    
            # 计算/统计与中间件的通讯耗时
            if self.calComUsedTime == 1:
                et = time.monotonic() # 返回当前时间的时间戳（1970纪元后经过的浮点秒数）
                calUsedTime.statisticsUsedTime(st, et, fnCode, rwCode) # 统计耗时
                if rs["status"] == ResponseStatus.MIDDLEWARE_COMMUNICATION_Timeout:
                    calUsedTime.recordTimeout(fnCode, rwCode)

            # 使用完后置为空闲状态
            self.busying = False
        except Exception:
            msg = traceback.format_exc()
            logger.error("发送并接收中间件相应的数据:出现异常!excetion:%s" % msg)

        self.threadLock.release() # 释放锁
        return rs


