'''
输入源使用状态变化事件.
'''
from H_9U.ctrl.up.evt.event import Event


class InputSourceUsedEvent(Event):

    def __init__(self, evtSender, evtType, deviceId, sourceId, isUsed, mac):
        super(InputSourceUsedEvent, self).__init__(evtSender, evtType, mac)

        self.deviceId = deviceId
        self.sourceId = sourceId
        self.isUsed = isUsed

    def __repr__(self):
        return 'InputSourceUsedEvent Event, deviceId: %s, sourceId: %s,isUsed: %s, mac: %s' % (self.deviceId, self.sourceId, self.isUsed, self.mac)