"""
@Project ：h_series 
@File    ：auth_code.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/4 11:15 
"""
import time

from H_9U.util.sqlitepool import pool, sqllock
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.log import logger


class AuthCodeDao:

    def __init__(self, conn_pool):
        self.pool = conn_pool

    def set_auth_code(self, sn, id_code, auth_code):
        """
        保存授权码到数据库
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'insert into device_auth_code (sn, id_code, auth_code, create_time) values (?, ?, ?, ?)'
                args = [sn, id_code, auth_code, int(time.time())]
                cursor.execute(sql, args)
                conn.commit()
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.Auth_Code_Add_Fail)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_auth_data(self, auth_code):
        """
        保存授权码到数据库
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'select id from device_auth_code where auth_code = ? limit 1'
                args = [auth_code]
                cursor.execute(sql, args)
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'id': row[0]
                    }
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.Auth_Code_Add_Fail)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def get_auth_code(self, id_code):
        """
        根据id_code查询授权码信息
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'select sn, id_code, auth_code, create_time from device_auth_code where id_code = ?'
                args = [id_code]
                cursor.execute(sql, args)
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'sn': row[0],
                        'idCode': row[1],
                        'authCode': row[2],
                        'createTime': row[3]
                    }
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs


auth_code_dao = AuthCodeDao(pool)