"""
@Project ：h_series 
@File    ：device_info_dao.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/12 11:31 
"""
from flask import json
from H_9U.models.sysconst import DeviceInfoType
from H_9U.util.sqlitepool import pool, sqllock
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.log import logger

class DeviceInfoDao:
    def __init__(self, conn_pool):
        self.pool = conn_pool

    def http_enable_read(self, device_id, key):
        """
        读取设备配置信息
        :param device_id: 设备id
        :param key: 配置key
        :return: 结果对象，数组
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select data_type, data_json from device_info where data_type=:data_type",
                               {"data_type": str(key)})
                row = cursor.fetchone()
                if row:
                    rs['data'] = json.loads(row[1])
        except Exception as e:
            logger.error(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs



    def http_enable_write(self, device_id, key, value):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("update device_info set data_json =:data_json where data_type =:data_type",
                               {"data_type": key, "data_json": json.dumps({"is_open":value})})
                conn.commit()
        except Exception as e:
            logger.error(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def update_package_pwd(self, package_pwd):
        """
        修改升级包密码
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'update device_info set data_json = ? where data_type = ?'
                args = [package_pwd, DeviceInfoType.PackagePwdType]
                cursor.execute(sql, args)
                conn.commit()
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
                conn.release()
        return rs

    def get_package_pwd(self):
        """
        查询升级包密码
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'select data_json from device_info where data_type = ?'
                args = [DeviceInfoType.PackagePwdType]
                cursor.execute(sql, args)
                row = cursor.fetchone()
                if row:
                    rs['data'] = {
                        'packagePwd': row[0]
                    }
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
                conn.release()
        return rs


    def ipDisplayed(self, device_id, is_displayed):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'update device_info set data_json = ? where data_type = ?'
                args = [json.dumps({"is_displayed": is_displayed}), DeviceInfoType.IsDisplayed]
                cursor.execute(sql, args)
                conn.commit()
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
                conn.release()
        return rs

    def ipDisplayedRead(self, device_id):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'select data_json from device_info where data_type = ?'
                args = [DeviceInfoType.IsDisplayed]
                cursor.execute(sql, args)
                conn.commit()
                row = cursor.fetchone()
                if row:
                    rs['data'] = json.loads(row[0])
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
                conn.release()
        return rs

    def is_preset_id_write(self, is_preset_id):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'update device_info set data_json = ? where data_type = ?'
                args = [json.dumps({"is_preset_id": is_preset_id}), DeviceInfoType.IsPresetId]
                cursor.execute(sql, args)
                conn.commit()
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
                conn.release()
        return rs

    def is_preset_id_read(self, device_id):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = 'select data_json from device_info where data_type = ?'
                args = [DeviceInfoType.IsPresetId]
                cursor.execute(sql, args)
                conn.commit()
                row = cursor.fetchone()
                if row:
                    rs['data'] = json.loads(row[0])
        except Exception as e:
            logger.exception(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
                conn.release()
        return rs

deviceInfodao = DeviceInfoDao(pool)