﻿"""
Created on 2019年6月28日
@author: 刘益宗
模块配置数据库访问
"""
from H_9U.util.sqlitepool import pool, sqllock
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.log import logger


class ModelConf:

    def __init__(self, conn_pool):
        self.pool = conn_pool

    def get_value(self, model, key):
        """
        根据模块和关键字Key获取配置的Value
        :param model: 模块
        :param key: 关键字
        :return: value
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select value from modelConf where model=? and key=?",
                               (model, key))
                row = cursor.fetchone()
                if row:
                    rs['data'] = {'value': int(row[0])}
                else:
                    rs['data'] = {'value': -1}
        except Exception as e:
            logger.error('ModelConf get error:' + str(e))
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def set_value(self, model, key, value):
        """
        根据模块和key设置配置值
        :param model: 模块
        :param key:  关键字
        :param value:  配置值
        :return:  成功失败
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            value = int(value)
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("delete from ModelConf where model=? and key = ?",
                               (model, key))
                cursor.execute("insert into ModelConf (model, key, value) values(?,?,?)",
                               (model, key, value))
                conn.commit()
        except Exception as e:
            logger.error('ModelConf set error:' + str(e))
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def delete_value(self, model, key):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("delete from ModelConf where model=? and key = ?",
                               (model, key))
                conn.commit()
        except Exception as e:
            logger.error('ModelConf set error:' + str(e))
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def delete_model(self, model):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("delete from ModelConf where model=? ",
                               (model,))
                conn.commit()
        except Exception as e:
            logger.error('ModelConf set error:' + str(e))
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def delete_value_by_prefix(self, model, prefix):
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = "delete from ModelConf where model='{}' and key like '{}%'".format(model, prefix)
                cursor.execute(sql)
                conn.commit()
        except Exception as e:
            logger.error('ModelConf set error:' + str(e))
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return get_result_model(ResInfo.DB_Error)


model_conf_dao = ModelConf(pool)
