"""
@Project ：h_series 
@File    ：security_dao.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/4 11:01 
"""
import time

from flask import json

from H_9U.util.sqlitepool import pool, sqllock
from H_9U.models.result import get_result_model, ResInfo
from H_9U.util.log import logger

_db_prefix = 'security_'

class SecurityDao:
    def __init__(self, conn_pool):
        self.pool = conn_pool

    def security_config_read(self, key):
        """
        读取设备配置信息
        :param device_id: 设备id
        :param key: 配置key
        :return: 结果对象，数组
        """

        rs = get_result_model()
        key = _db_prefix + key
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("select data_type, data_json from device_info where data_type=:data_type",
                               {"data_type": str(key)})
                row = cursor.fetchone()
                if row:
                    rs['data'] = json.loads(row[1])
        except Exception as e:
            logger.error(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def security_config_read_all(self):
        """
        读取设备配置信息
        :param device_id: 设备id
        :param key: 配置key
        :return: 结果对象，数组
        """
        rs = get_result_model()
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                sql = "select data_type, data_json from device_info where data_type  like '%" + _db_prefix + "%'"
                cursor.execute(sql)
                rows = cursor.fetchall()
                if rows:
                    for row in rows:
                        key = row[0].replace(_db_prefix, '')
                        rs['data'][key] = json.loads(row[1])
        except Exception as e:
            logger.error(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

    def security_config_write(self, key, value):
        rs = get_result_model()
        db_key = _db_prefix + key
        try:
            sqllock.acquire()
            conn = self.pool.get()
            with conn:
                cursor = conn.cursor()
                cursor.execute("update device_info set data_json =:data_json where data_type =:data_type",
                               {"data_type": db_key, "data_json": json.dumps(value)})
                conn.commit()
        except Exception as e:
            logger.error(e)
            rs = get_result_model(ResInfo.DB_Error)
        finally:
            if sqllock.locked():
                sqllock.release()
        return rs

securitydao = SecurityDao(pool)
