from H_9U.mao.impl import bkg
from H_9U.util.cache import cacher
from H_9U.models.cachekey import CacheKey, CacheDuration

class BkgApi:
    """
    bkg接口api，直接调用mao层
    处理缓存和业务逻辑
    """
    def read_list(self, device_id):
        """
        读取bkg列表并加入缓存
        :param device_id:
        :return: 结果数据
        """
        key = CacheKey.bkg_list(device_id)
        return cacher.BkgCache.try_get_value(key, CacheDuration.Default, bkg.bkg_list_read, device_id)

    def read_detail(self, device_id, bkg_id):
        """
        读取bkg详情并加入缓存
        :param device_id: 设备id
        :param bkg_id: bkgId
        :return: 结果数据
        """
        key = CacheKey.bkg_detail(device_id, bkg_id)
        return cacher.BkgCache.try_get_value(key, CacheDuration.Default, bkg.bkg_full_detail_read, device_id, bkg_id)

    def write_create(self, device_id, data):
        """
        创建bkg
        移除bkg列表缓存
        移除bkg详情缓存
        :param device_id: 设备Id
        :param data: bkg数据
        :return:
        """
        bkg_id = data.get('bkgId')
        rs = bkg.bkg_create_write(device_id, data)
        if rs['status'] == 0:
            cacher.BkgCache.delete(CacheKey.bkg_detail(device_id, bkg_id))
            cacher.BkgCache.delete(CacheKey.bkg_list(device_id))
        return rs

    def write_delete(self, device_id, bkg_id, data):
        """
        删除bkg
        移除bkg详情缓存
        移除bkg列表缓存
        :param device_id: 设备id
        :param bkg_id: bkgid
        :param data: 数据对象
        :return: 结果对象
        """
        rs = bkg.bkg_delete_write(device_id, bkg_id, data)
        if rs['status'] == 0:
            cacher.BkgCache.delete(CacheKey.bkg_detail(device_id, bkg_id))
            cacher.BkgCache.delete(CacheKey.bkg_list(device_id))
        return rs

    def read_general(self, device_id, bkg_id):
        """
        读取bkg基本信息
        :param device_id: 设备Id
        :param bkg_id: bkgid
        :return: bkg基本信息
        """
        return bkg.bkg_general_read(device_id, bkg_id)

    def write_general(self, device_id, bkg_id, data):
        """
        设置bkg基本信息，主要是名称
        移除bkg列表缓存
        移除bkg详情缓存
        :param device_id:
        :param bkg_id:
        :param data:
        :return:
        """
        rs = bkg.bkg_general_write(device_id, bkg_id, data)
        if rs['status'] == 0:
            cacher.BkgCache.delete(CacheKey.bkg_detail(device_id, bkg_id))
            cacher.BkgCache.delete(CacheKey.bkg_list(device_id))
        return rs


bkg_api = BkgApi()

