"""
Created on 2019年6月28日
@author: 刘益宗
输出接口.
对应协议中的<output>.
"""
from H_9U.models.sysconst import ReadSign
from H_9U.protocol.fncode import FnCode
from H_9U.models.result import transfer_midware_resp
from H_9U import controller as ctrl
from H_9U.util.logwrapper import log_wrapper
from H_9U.util.formatdata import format_server_data, format_client_data


@log_wrapper
def output_list_read(device_id):
    """
    输出列表数据
    :param device_id: 设备Id
    :return: 参考接口outputList
    """
    rs = transfer_midware_resp(ctrl.read(FnCode.OUTPUT_LIST, device_id, ReadSign.Is_ALL))
    format_server_data(rs['data'])
    return rs


@log_wrapper
def output_full_detail_read(device_id, output_id):
    """
    输出详细信息
    :param device_id: 设备Id
    :param output_id:  输出Id
    :return: 参考接口outputFullDetail
    """
    rs = transfer_midware_resp(ctrl.read(FnCode.OUTPUT_FULL_DETAIL, device_id, output_id))
    format_server_data(rs['data'])
    return rs


@log_wrapper
def output_general_read(device_id, output_id):
    """
    读取常规信息
    :param device_id: 设备号
    :param output_id: 输出ID
    :return: 参考接口outputGeneral
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_GENERAL, device_id, output_id))


@log_wrapper
def output_general_write(device_id, output_id, data):
    """
    设置输出常规信息
    :param device_id: 设备id
    :param output_id: 输出id
    :param data:  json data
    :return: 参考接口outputGeneral
    """
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_GENERAL, [data], device_id, output_id))


@log_wrapper
def output_test_pattern_write(device_id, output_id, data):
    """
    设置测试画面信息
    :param device_id: 设备号
    :param output_id: 输出ID
    :param data: json data
    :return: 参考接口outputTestPattern
    """
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_TEST_PATTERN, [data], device_id, output_id))


@log_wrapper
def output_test_pattern_read(device_id, output_id):
    """
    读取测试画面信息
    :param device_id: 设备号
    :param output_id: 输出ID
    :return: 参考接口outputTestPattern
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_TEST_PATTERN, device_id, output_id))


@log_wrapper
def output_crop_read(device_id, output_id):
    """
    读取输出截取
    :param device_id: 设备Id
    :param output_id:  输出ID
    :return: 参考接口outputCrop
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_CROP, device_id, output_id))


@log_wrapper
def output_crop_write(device_id, output_id, data):
    """
    设置输出截取
    :param device_id:  设备Id
    :param output_id:  输出ID
    :param data: json
    :return: 参考接口outputCrop
    """
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_CROP, [data], device_id, output_id))


@log_wrapper
def output_timing_read(device_id, output_id):
    """
    读指定output的timing信息.
    :param device_id: 设备号
    :param output_id: 输出ID
    :return: 参考接口outputTiming
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_TIMING, device_id, output_id))


@log_wrapper
def output_timing_write(device_id, output_id, data):
    """
    设置Timing.
    :param device_id: deviceId:设备号
    :param output_id: 输出ID
    :param data: json
    :return: 参考接口outputTiming
    """
    format_client_data(data)
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_TIMING, [data], device_id, output_id))


@log_wrapper
def output_edid_read(device_id, output_id):
    """
    读指定output的EDID信息.
    :param device_id: 设备号
    :param output_id: 输出ID
    :return: 参考接口edid
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_EDID, device_id, output_id))


@log_wrapper
def output_image_quality_write(device_id, output_id, data):
    """
    设置指定output的画质
    :param device_id: 设备ID
    :param output_id: 输出ID
    :param data: json
    :return: 参考接口outputImageQuality
    """
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_IMAGEQUALITY, [data], device_id, output_id))


@log_wrapper
def output_image_quality_read(device_id, output_id):
    """
    读取指定output的画质.
    :param device_id: 设备ID
    :param output_id: 输出ID
    :return:参考接口outputImageQuality
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_IMAGEQUALITY, device_id, output_id))


@log_wrapper
def output_gamma_read(device_id, output_id):
    """
    读取指定gamma数据
    :param device_id: 设备ID
    :param output_id: 输出ID
    :return: 参考接口outputGamma
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_GAMMA, device_id, output_id))


@log_wrapper
def output_gamma_write(device_id, output_id, data):
    """
    读取指定gamma数据
    :param device_id: 设备ID
    :param output_id: 输出ID
    :param data: gamma数据
    :return:参考接口outputGamma
    """
    format_client_data(data)
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_GAMMA, data, device_id, output_id))


@log_wrapper
def output_match_res_read(device_id, output_id):
    """
    获取输出所接显示设备的最佳分辨率信息
    :param device_id: 设备ID
    :param output_id: 输出ID
    :return: 参考接口outputMatchRes
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_MATCHRES, device_id, output_id))


@log_wrapper
def output_fixed_position_read(device_id, output_id):
    """
    显示输出接口定位信息
    :param device_id: 设备Id
    :param output_id: 输出Id
    :return: 参考接口outputFixedPosition
    """
    return transfer_midware_resp(ctrl.read(FnCode.OUTPUT_FIXEDPOSITION, device_id, output_id))


@log_wrapper
def output_fixed_position_write(device_id, output_id, data):
    """
    设置输出接口定位信息
    :param device_id: 设备Id
    :param output_id: 输出Id
    :param data: json
    :return:参考接口outputFixedPosition
    """
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_FIXEDPOSITION, [data], device_id, output_id))

@log_wrapper
def output_timing_free_mapping(device_id, output_id, data):
    format_client_data(data)
    return transfer_midware_resp(ctrl.write(FnCode.OUTPUT_TIMING_FREE_MAPPING, data if isinstance(data, list) else [data], device_id, output_id))
