"""
Created on 2019年6月28日
@author: 刘益宗
系统错误码数据
"""
from enum import Enum


def get_result_model(res_info=None):
    """
    获取返回对象
    :param res_info: ResInfo实例，有则使用，没有则返回成功
    :return: {'status': 0, 'msg':'success', 'data': None}
    """
    if not res_info or not isinstance(res_info, Enum):
        res_info = ResInfo.Success

    return {'status': res_info.value, 'msg': res_info.name, 'data': {}}


def get_result_list_model():
    """
    返回成功结果mode，data为[]
    :return: {'status': 0, 'msg':'success', 'data': []}
    """
    return {
        'status': ResInfo.Success.value,
        'msg': ResInfo.Success.name,
        'data': []}


class ResInfo(Enum):
    """
    错误消息和错误代码
    """

    # 0 成功，999 未知错误
    Success = 0  # 成功
    Server_Err = 500  # 服务错误
    Unknow_Error = 999  # 未知错误

    # 1-99 段 通用错误
    Params_Error = 1  # 参数错误
    DB_Error = 2  # 数据库错误
    Request_Json_Error = 3  # 请求json错误
    Biz_Id_Err = 4  # 业务Id错误
    Verify_Req_Error = 5  # 请求校验错误

    Upload_File_Fail = 6  # 上传文件失败
    File_Not_Exists = 7  # 文件不存在
    Middle_Data_Err = 8   # 中间数据处理错误
    File_Support_Err = 9  # 文件类型不支持错误

    Response_Invalid = 10  # 无效的应答，设备过期
    Device_Date_Err = 11  # 设备时间错误
    Extract_File_Err = 12  # 解压文件失败
    Open_Project_Illegal_Err = 13  # 该用户账号非法
    Open_Repeat_Err = 14   # 该账号重复
    Open_Id_Illegal_Err = 15  # ID非法
    Open_key_Illegal_Err = 16  # 密钥重复
    Params_Type_Error = 17  # 参数类型错误
    Sign_Error = 18  # 签名错误
    Decrypt_Error = 21  # 解密错误

    # 中间件异常错误码
    Over_Write = 80
    Repeat_Err = 81  # 请求资源重复
    Device_Linking_Timeout = 82  # 设备连接超时
    Reqyest_Checksum_Error = 83  # 请求sum校验错误
    Invalid_CMD = 84  # 不合法命令
    Len_Error = 85  # 数据长度错误
    DVI_ENCRYPTION = 86  #
    Middleware_Communication_Timeout = 87  # 中间件通信超时
    Middleware_Communication_Falure = 88  # 中间件通信错误
    Middleware_Data_Falure = 89  # 中间件数据错误

    Over_Run = 91  # over run
    Verify_Ans_Error = 92
    Midware_Timeout = 93   # 中间件超时
    Not_Valid_Cmd = 94  # 无效命令
    Length_Ans_Error = 95  # 应答长度错误
    Program_Config_Error = 96  # 程序配置错误
    Midware_Inner_Error = 97  # 中间件内部错误
    Respond_ACK_Error = 98  # 应答错误
    Respond_Error = 99  # 响应错误

    # 100段 user
    User_Not_Exist = 101  # 用户不存在
    User_Password_Error = 102  # 用户名密码错误
    User_Not_Active = 103  # 用户不可用
    User_Name_Exist = 104  # 用户名已经在
    User_Add_Faild = 105  # 添加用户错误
    User_Not_Login = 106  # 用户未登录
    User_Token_Not_Valid = 107  # 用户token不合法
    User_Token_Expired = 108  # 用户token过期
    User_Delete_Error = 109  # 用户删除错误
    User_Func_Err = 110  # 用户权限错误
    Device_Auth_User_Info_Err = 111  # 设备授权用户信息错误
    Open_Info_Delete_Err = 112  # 第三方信息删除错误
    Open_Info_Update_Err = 113  # 第三方信息修改错误
    Open_Info_Add_Err = 114  # 第三方信息添加错误
    User_Add_Role_Err = 115  # 用户添加角色
    User_Name_No_Edit = 116  # 用户名不准修改
    User_Email_Format_Err = 117  # 用户邮箱格式错误
    User_Phone_Format_Err = 118  # 用户电话格式错误
    Auth_Code_Add_Fail = 119  # 添加授权码错误
    User_Verify_Code_Err = 120
    User_Update_Role_Err = 121  # 用户更新角色
    User_Update_Status_Err = 122  # 用户更新状态错误
    User_Login_Err_Need_Verify_Code = 123
    User_Login_Locked = 124
    User_Login_Err = 125
    User_Password_Invalid = 126  # 用户密码不合法
    User_Name_Invalid = 127  # 用户名称不合法

    # 200段 input
    Input_Write_EDID_List_Error = 201   # 批量设置edid错误
    Input_Write_Timing_List_Error = 202  # 批量设置timing错误
    Input_Write_Timing_List_Partial_Success = 203  # 批量设置timing部分成功
    Input_Write_EDID_List_Partial_Success = 204
    Input_IPC_Montage_Not_Exists = 205  # ipc拼接不存在
    Input_IPC_Montage_Fail = 206  # ipc拼接失败
    Input_IPC_Source_Is_Used = 207  # IPC信号源被占用
    Input_Is_Used = 208  # 输入源被占用
    Input_IPC_Slot_Source_Max_Count_Err = 209  # ipc slot 信号源数量错误
    Input_Group_Max_Count_Err = 210  # 输入分组最大个数超限
    Input_IPC_Montage_Not_Allowed = 211  # 不允许操作ipc拼接
    Input_IPC_Not_Exists = 212  # ipc卡不存在
    Input_Write_Timing_Error = 213  # 设置timing错误
    Input_IPC_Channel_Detail_Err = 214  # ipc源通道详情失败
    Input_IPC_Slot_Source_Channel_Max_Count_Err = 215  # ipc slot 信号源通道数量错误
    Input_IPC_Slot_Source_Append_Err = 216  # ipc slot 信号源追失败
    Input_IPC_Slot_Source_Add_ip_Err = 217  # ipc源新增ip格式错误
    Input_IPC_Channel_List_Err = 218  # ipc 源通道列表失败
    Input_RefreshRate_Err = 219  # 刷新率不能小于0
    Input_IPC_Export_Source_Err = 220  # ipc 导出源信息失败
    Input_IPC_Import_Progress_Fail_Err = 221  # ipc 查询导入进度失败
    Input_IPC_Import_Cancel_Fail_Err = 222  # ipc 取消导入失败
    Input_IPC_Import_File_Fmt_Err = 223  # ipc 导入文件格式错误
    Input_IPC_Import_Data_Err = 224  # ipc 导入数据错误
    Input_IPC_Create_Template_Err = 226  # IPC 模板创建失败
    Input_FILE_Import_Err = 227 # SDP文件导致错误
    Input_Support_Err = 228  # HDMI(1.3/1.4)DVI(SL/DL)timing不相同
    Input_IPC_Source_Repeat_Err = 229 # IPC信号源在轮训源中使用，无法参与拼接
    Input_Source_Used_Err = 230 # 轮训源使用中,禁止操作
    Input_IPC_Source_type_Err = 231  # IPC 源类型错误

    # 300段 output
    Output_Write_EDID_Error = 301  # 输出edid设置错误
    Output_Write_Timing_List_Error = 302  # 批量设置timing错误
    Output_Timing_Err = 303  # output timing 错误
    Output_Is_Used = 304  # 输出被占用
    Output_Read_Error = 305  # 读取output错误
    Output_Crop_Error = 306  # 输出截取错误
    Output_Crop_Partial_Success = 307  # 设置输出截取部分成功
    Output_Max_Payload_Exceed = 308  # 输出最大带载超限
    Output_Support_Err = 309  # HDMI(1.3/1.4)DVI(SL/DL)timing不相同

    # 400段 screen
    Screen_List_Empty = 401  # 屏幕列表为空
    Screen_Output_Used = 402  # 屏幕输出口被使用
    Screen_Output_Not_Available = 403  # 屏幕输出口不可用
    Screen_Not_Exist = 404  # 屏幕不存在
    Screen_Output_Crops_Partial_Success = 405  # 屏幕设置输出截取部分成功
    Screen_Output_Not_Found = 406  # 屏幕输出口未找到
    Screen_Test_Pattren_Error = 407
    Screen_Create_Err = 408
    Screen_Detail_Error = 409
    Screen_Setting_Not_Allowed = 410
    Screen_Is_Preset_Polling = 411  # 正在场景轮循
    Screen_OSD_Limit_Err = 412  # 屏幕osd超限
    Screen_TwoInOneCard_Err = 413  # 二合一卡配平错误
    Screen_OSD_Words_Length_Err = 414  # 屏幕words osd 长度超限
    Screen_Over_Run = 415  # 屏幕资源超限
    Screen_Support_Err = 416  # 屏幕不支持此操作
    Screen_Layout_Delete_Err = 417  # 布局被使用，不能删除
    Screen_Name_Repeat_Err = 418  # 屏幕名称重复
    Screen_Time_OSD_Limit_Err = 419  # 不能删除


    # 500段 layer
    Layer_Delete_Err = 501

    # 600段 bkg
    BKG_Name_Exists = 601  # bkg名称已存在
    BKG_Not_Exist = 602  # bkg不存在
    BKG_Exceeds_Limit = 603  # bkg尺寸超限
    BKG_Exists_Count_Err = 604  # 查询bkg数量错误
    BKG_Max_Count_Limit_Error = 605  # bkg数量超限
    BKG_Query_Error = 606  # bkg查询错误
    BKG_Batch_Delete_Partial_Success = 607  # bkg批量删除错误
    BKG_Used_In_Screen = 608  # bkg被屏幕使用
    # 700段 mvr
    MVR_Window_Batch_Delete_Partial_Success = 701  # 批量删除mvrwindow部分成功
    MVR_Window_List_Error = 702  # 查询mvr window列表错误
    # 800段 场景
    Preset_List_Error = 801   # 查询场景列表错误
    Preset_Batch_Delete_Part_Success = 802  # 批量删除场景部分成功
    Preset_Detail_Err = 803  # 读取场景详细信息Err
    Preset_Group_Empty = 804  # 场景分组为空

    # 900段 设备
    Device_Slot_Interface_Not_Exist = 901   # 设备子卡接口不存在
    Device_Slot_Not_Exist = 902  # 设备子卡不存在
    Device_Detail_Error = 903  # 设备详情错误
    Device_Busy = 904  # 设备忙碌
    Device_Power_Off = 905  # 设备断电
    Device_Subcard_Slot_Err = 906  # 设备子卡槽错误
    Device_Subcard_Model_Id_Err = 907  # 设备子卡ModelId错误
    Device_Subcard_Sum_Err = 908  # 设备子卡SUM错误
    Device_Upgrade_Fail = 909  # 升级失败
    Device_Upgrade_Parts_Empty = 910  # 固件升级节点为空
    Device_Upgrade_File_Error = 911  # 固件升级失败
    Device_Is_Initing = 912  # 设备正在初始化
    Device_Is_Upgrading = 913  # 设备正在升级
    Device_Is_Checking = 914  # 设备正在自检
    Device_Is_Setting = 915  # 设备正在导入配置
    Device_Setting_File_Err = 916  # 设备导入文件错误
    Device_Ip_Invalid = 917  # 设备ip不合法
    Device_SubnetMask_Invalid = 918  # 设备子网掩码不合法
    Device_Font_Exceeds_Limit = 919  # 字体超限
    Device_Central_Cmd_Exceeds_Limit = 920  # 中控指令数量超限
    Device_Ip_Conflict = 921  # IP冲突
    Device_Lcd_Setting_Err = 922 # 设置lcd屏幕相关错误
    Device_Edid_Setting_Err = 923  # edid 格式错误

    # 1000段 角色
    Role_Name_Exist = 1000  # 角色已经存在
    Role_No_Delete = 1001  # 角色不准删除
    Role_Max_Count = 1002  # 角色超过100
    Role_Data_Err = 1003  # 角色数据错误
    Role_Update_Err = 1004  # 角色更新错误
    Role_No_Update_Admin = 1005  # 不准用户更新为超级管理员
    Role_Jurisdiction_Code = 1006  # 没有权限

    Auth_Code_Expired = 2001  # 授权码过期


class MidwareErr:
    """
    中间件错误码列表
    """
    ACKOK = 0x00
    TIMEOUT = 0x01
    VERIFYREQERROR = 0x02
    VERIFYANSERROR = 0x03
    NOTVALIDCMD = 0x04
    LENGTHANSERROR = 0x05
    PROGRAMCONFIGERROR = 0x06
    INNERERROR = 0x07
    RESPONDACKERROR = 0x08
    RESPONDERROR = 0x09
    RESPONSEINVALID = 0x0A
    DEVICEUPGRADING = 0X0B
    ERR_F_DEVICENOTUPGRADE = 0x0C
    IDERROR = 0x10
    OVERRUN = 0x11
    REPEATERR = 0x12
    OVERWRITE = 0x13
    OSD_LIMIT_ERR = 0x14
    DEVICE_INITING = 0x15
    IP_CONFLICT_ERR = 0x16
    RESOURCE_USED_ERROR = 0x17  # 轮训源使用中,禁止操作
    RESOURCE_BUSY_ERROR = 0x18  # IPC信号源在轮训源中使用，无法参与拼接
    SUBCARD_SUMERR = 0x21
    SUBCARD_MODELIDERR = 0x22
    SUBCARD_SLOTIDERR = 0x23
    DEVICE_PWOER_OFF = 0x31
    SCREEN_NAME_ERR = 0x41
    DEVICE_BUSY = 0x50
    SDP_ERR = 0x60
    EDID_ERR = 0x61

    # 通讯异常错误码，非中间件返回
    DEVICE_LINKING_TIMEOUT = 301
    # REQUEST_CHECKSUM_ERR = 2
    REQUEST_CHECKSUM_ERR = 302
    INVALID_CMD = 303
    LEN_ERR = 304
    DVI_ENCRYPTION = 305
    MIDDLEWARE_COMMUNICATION_Timeout = 306
    MIDDLEWARE_COMMUNICATION_FALURE = 307
    MIDDLEWARE_DATA_FALURE = 308

    Midware_Server_Status_Map = {
        DEVICE_BUSY: ResInfo.Device_Busy,
        DEVICE_PWOER_OFF: ResInfo.Device_Power_Off,
        SUBCARD_SLOTIDERR: ResInfo.Device_Subcard_Slot_Err,
        SUBCARD_MODELIDERR: ResInfo.Device_Subcard_Model_Id_Err,
        SUBCARD_SUMERR: ResInfo.Device_Subcard_Sum_Err,
        IDERROR: ResInfo.Biz_Id_Err,
        TIMEOUT: ResInfo.Midware_Timeout,
        VERIFYREQERROR: ResInfo.Verify_Req_Error,
        VERIFYANSERROR: ResInfo.Verify_Ans_Error,
        NOTVALIDCMD: ResInfo.Not_Valid_Cmd,
        LENGTHANSERROR: ResInfo.Length_Ans_Error,
        PROGRAMCONFIGERROR: ResInfo.Program_Config_Error,
        INNERERROR: ResInfo.Midware_Inner_Error,
        RESPONDACKERROR: ResInfo.Respond_ACK_Error,
        RESPONDERROR: ResInfo.Respond_Error,
        OVERRUN: ResInfo.Over_Run,
        REPEATERR: ResInfo.Repeat_Err,
        OVERWRITE: ResInfo.Over_Write,
        RESPONSEINVALID: ResInfo.Response_Invalid,
        DEVICE_INITING: ResInfo.Device_Is_Initing,
        DEVICE_LINKING_TIMEOUT: ResInfo.Device_Linking_Timeout,
        REQUEST_CHECKSUM_ERR: ResInfo.Reqyest_Checksum_Error,
        INVALID_CMD: ResInfo.Invalid_CMD,
        LEN_ERR: ResInfo.Len_Error,
        DVI_ENCRYPTION: ResInfo.DVI_ENCRYPTION,
        MIDDLEWARE_COMMUNICATION_Timeout: ResInfo.Middleware_Communication_Timeout,
        MIDDLEWARE_COMMUNICATION_FALURE: ResInfo.Middleware_Communication_Falure,
        MIDDLEWARE_DATA_FALURE: ResInfo.Middleware_Data_Falure,
        OSD_LIMIT_ERR: ResInfo.Screen_OSD_Limit_Err,
        DEVICEUPGRADING: ResInfo.Device_Is_Upgrading,
        ERR_F_DEVICENOTUPGRADE: ResInfo.Device_Upgrade_Fail,
        SCREEN_NAME_ERR: ResInfo.Screen_Name_Repeat_Err,
        SDP_ERR : ResInfo.Input_FILE_Import_Err,
        IP_CONFLICT_ERR: ResInfo.Device_Ip_Conflict,
        EDID_ERR: ResInfo.Device_Edid_Setting_Err,
        RESOURCE_USED_ERROR: ResInfo.Input_Source_Used_Err,
        RESOURCE_BUSY_ERROR: ResInfo.Input_IPC_Source_Repeat_Err,
    }


def _map_midware_status(res):
    """
    转换中间件状态码
    :param res: 中间件结果
    :return: 系统状态码
    """
    status = res['status']
    data = res.get('data')
    if status in MidwareErr.Midware_Server_Status_Map:
        res = get_result_model(MidwareErr.Midware_Server_Status_Map[status])
        res['data'] = data
    else:
        msg = str(res)
        res = get_result_model(ResInfo.Unknow_Error)
        res['data'] = msg
    return res


def transfer_midware_resp(res):
    """
    转换中间件返回结果数据
    :param res: 中间件结果
    :return: server数据
    """
    if res['status'] == 0:
        if res['data']:
            res['data'] = res['data'][0]
    else:
        if res['status'] == 10:
            from H_9U.util.cache import cacher
            cacher.clear_all()
        res = _map_midware_status(res)
    return res
