"""
Created on 2021年9月14日
@author: 程声清
layer服务类
"""
from H_9U.open.middle import open_layer_middle, open_screen_middle
from H_9U.models.result import get_result_model, ResInfo


def layer_screen_no_time_play(device_id, screen_id, params):
    """
    屏幕非实时上屏take
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param params: 图层信息
    :return: 结果对象
    """
    # layers = params.get('layers', None)
    # no_time = params.get('enNonTime', 0)
    rs = open_screen_middle.screen_no_time_play_middle(
        device_id, screen_id, params)
    # if rs['status'] == 0:
    #     open_layer_middle.layer_delete_lock_by_screen_middle(
    #         device_id, screen_id)
    #     if layers:
    #         for layer in layers:
    #             layer_id = layer['layerId']
    #             if layer_id is not None:
    #                 if no_time == 1:
    #                     open_layer_middle.layer_write_lock_middle(
    #                         device_id, screen_id, layer_id, 1, 1)
    #                 else:
    #                     open_layer_middle.layer_write_lock_middle(
    #                         device_id, screen_id, layer_id, 0, 1)
    #                     open_layer_middle.layer_write_lock_middle(
    #                         device_id, screen_id, layer_id, 1, 0)
    return rs


def layer_create(device_id, screen_id, params):
    """
    创建图层
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param params: 中间件协议文档LayerCreate
    :return: {'id':0, 'layersZOrder':[xxx]}
    """
    rs = open_layer_middle.layer_write_create_middle(
        device_id, screen_id, params)
    return rs


def _screen_non_time(device_id, screen_id):
    """
    屏幕非实时nonTime
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :return: 结果对象
    """
    from H_9U.open.service import open_screen_svc
    rs = open_screen_svc.screen_read_detail(device_id, screen_id)
    if rs['status'] == 0:
        return rs['data']['nonTime']


def layer_delete(device_id, screen_id, layer_id):
    """
    删除图层
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param layer_id: 图层号
    :return: 结果对象
    """
    non_time = _screen_non_time(device_id, screen_id)
    if non_time is None:
        return get_result_model(ResInfo.Middle_Data_Err)
    else:

        data = {
            "screenId": screen_id,
            "deviceId": device_id,
            "layerId": layer_id
        }
        rs = open_layer_middle.layer_write_delete_middle(
            device_id, screen_id, layer_id, data)
        # if rs['status'] == 0:
        #     open_layer_middle.layer_write_lock_middle(
        #         device_id, screen_id, layer_id, 0, non_time)
    return rs


def layer_read_detail(device_id, screen_id, layer_id):
    """
    读取屏幕详细信息
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param layer_id: 图层Id
    :return: 参考readDetail文档
    """
    # from H_9U.service import open_screen_svc
    # rs = open_screen_svc.screen_layer_detail_list(device_id, screen_id)
    # if rs['status'] == 0 and rs['data']:
    #     rs['data'] = rs['data']['screenLayers']
    #     detail = [x for x in rs['data'] if x['layerId'] == layer_id]
    #     if detail:
    #         rs['data'] = detail[0]
    #     else:
    #         rs['data'] = {}
    rs = open_layer_middle.layer_read_detail_middle(
        device_id, screen_id, layer_id)
    return rs


def layer_write_general(device_id, screen_id, layer_id, data):
    """
    读取图层基本信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param layer_id: 图层号
    :param data: 参考中间件接口协议
    :return: 标准返回
    """
    return open_layer_middle.layer_general_write_middle(
        device_id, screen_id, layer_id, data)


def layer_read_z_index(device_id, screen_id):
    """
      设置图层source 信息
      :param device_id: 设备Id
      :param screen_id: 屏幕id
      :return: 参考中间件协议
      """
    return open_layer_middle.layer_read_z_index_middle(device_id, screen_id)


def layer_write_layout_window(device_id, screen_id, layer_id, data):
    """
     设置图层窗口信息
     :param device_id: 设备Id
     :param screen_id: 屏幕id
     :param layer_id: 图层号
     :param data: 参考中间件接口协议
     :return: 标准返回
     """
    # 判断图层Id<0返回参数错误
    if layer_id < 0:
        return get_result_model()
    return open_layer_middle.layer_write_layout_window_middle(
        device_id, screen_id, layer_id, data)


def layer_clear(device_id, screen_id):
    """
    清空屏幕图层
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :return: 结果对象
    """
    rs = open_screen_middle.screen_clear_layers_middle(device_id, screen_id)
    # if rs['status'] == 0:
    #     open_layer_middle.layer_delete_lock_by_screen_middle(
    #         device_id, screen_id)
    return rs


def layer_write_z_index(device_id, screen_id, data):
    """
    设置图层Z序
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param data: 参考中间件接口协议
    :return: 参考中间件协议
    """
    return open_layer_middle.layer_write_z_index_middle(
        device_id, screen_id, data)


def layer_write_z_lock(device_id, screen_id, layer_id, is_lock):
    """
    设置图层锁定
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param layer_id: 图层Id
    :param is_lock: 是否锁定
    :return:
    """
    non_time = _screen_non_time(device_id, screen_id)
    if non_time is not None:
        rs = open_layer_middle.layer_write_lock_middle(
            device_id, screen_id, layer_id, is_lock)
    else:
        rs = get_result_model(ResInfo.Middle_Data_Err)
    return rs


def layer_write_source(device_id, screen_id, layer_id, data):
    """
    设置图层source 信息
    :param device_id: 设备Id
    :param screen_id: 屏幕id
    :param layer_id: 图层号
    :param data: 参考中间件接口协议
    :return: 标准返回
    """
    return open_layer_middle.layer_write_source_middle(
        device_id, screen_id, layer_id, data)


def layer_freeze(device_id, screen_id, layer_id, data):
    """
    屏幕图层上屏
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param layer_id: 图层id
    :param data:
    :return: 结果对象
    """
    return open_layer_middle.layer_freeze_middle(
        device_id, screen_id, layer_id, data)


def screen_layer_layout(device_id, screen_id, data):
    """
    屏幕图层自动布局（模板开窗）
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data: 图层数据
    :return: 结果对象
    """
    layers = data.get('layers', None)
    if layers is None:
        return get_result_model(ResInfo.Params_Error)
    return open_layer_middle.write_screen_layer_layout_middle(
        device_id, screen_id, data)


def write_stream_rule(device_id, data):
    """
    屏幕图层自动布局（模板开窗）
    :param device_id: 设备Id
    :param screen_id: 屏幕Id
    :param data: 图层数据
    :return: 结果对象
    """
    return open_layer_middle.write_layer_stream_rule(
        device_id, data)
