"""
Created on 2019年6月28日
@author: 刘益宗
mvrwindow服务
返回值统一为 {data:JSON结构体, msg:"", status:0}
"""
import time

from H_9U.models.result import get_result_model, ResInfo
from H_9U.mao.mvrwindow_mao import mvrwindow_api
from H_9U.util.log import logger


class MvrWindowSvc:

    def mvr_window_list_read(self, device_id, mvr_id):
        """
        读取mvr window 列表
        :param device_id: 设备id
        :param mvr_id:  mvr id
        :return:  列表数据，参考中间件协议文档
        """
        return mvrwindow_api.read_list(device_id, mvr_id)

    def mvr_window_all_read(self, device_id, mvr_id):
        """
        读取全部mvrWindow信息
        :param device_id: 设备Id
        :param mvr_id: mvrid
        :return: mvrWindow 详情列表
        """
        rs = self.mvr_window_list_read(device_id, mvr_id)
        window_list = []
        if rs['status'] == 0 and rs['data']:
            for window in rs['data']['MVRWindows']:
                window_id = window['windowId']
                rs = self.mvr_window_detail_read(device_id, mvr_id, window_id)
                if rs['status'] == 0 and rs['data']:
                    window_list.append(rs['data'])
            rs = get_result_model()
            rs['data'] = window_list
        return rs

    def mvr_window_all_info_read(self, device_id, mvr_id):
        """
        读取mvr window 列表
        :param device_id: 设备id
        :param mvr_id:  mvr id
        :return:  列表数据，参考中间件协议文档
        """
        rs = mvrwindow_api.read_list(device_id, mvr_id)
        if rs['status'] == 0 and rs['data']:
            detail_list = []
            for mw in rs['data']['MVRWindows']:
                window_id = mw['windowId']
                detail_list.append(self.mvr_window_detail_read(device_id, mvr_id, window_id))
            rs = get_result_model()
            rs['data'] = detail_list
        return rs

    def mvr_window_create(self, device_id, mvr_id, data):
        """
        创建窗口
        :param data: 创建参数
        :return:  窗口Id
        """
        rs = mvrwindow_api.write_create(device_id, mvr_id, data)
        if rs['status'] == ResInfo.Over_Write.value:
            window = rs['data'][0]
            window['status'] = ResInfo.Over_Write.value
            rs['data'] = window
            rs['status'] = 0
        elif rs['status'] == 0:
            rs['data']['status'] = 0
        return rs

    def mvr_window_delete(self, device_id, mvr_id, window_id, params):
        """
        删除窗口
        :param params: 接口参数
        :param device_id: 设备Id
        :param mvr_id: mvrId
        :param window_id: 窗口Id
        :return: 删除结果对象
        """
        return mvrwindow_api.write_delete(device_id, mvr_id, window_id, params)

    def mvr_window_general_read(self, device_id, mvr_id, window_id):
        """
        读取窗口基本信息
        :param params:  窗口数据
        :return: 参考前端接口文档
        """
        return mvrwindow_api.read_general(device_id, mvr_id, window_id)

    def mvr_window_general_write(self, device_id, mvr_id, window_id, params):
        """
        设置窗口基本信息
        :param params:  窗口数据
        :return: 参考前端接口文档
        """
        return mvrwindow_api.write_general(device_id, mvr_id, window_id, params)

    def mvr_window_border_width_write(self, device_id, mvr_id, window_id, params):
        """
        设置窗口边框宽度
        :param params: 边框数据
        :param device_id:设备Id
        :param mvr_id: mvr id
        :param window_id: 窗口id
        :return: 结果对象
        """
        return mvrwindow_api.write_border_width(device_id, mvr_id, window_id, params)

    def mvr_window_border_color_write(self, device_id, mvr_id, window_id, params):
        """
        设置窗口边框颜色
        :param params: 颜色信息
        :param device_id:设备Id
        :param mvr_id: mvr id
        :param window_id: 窗口id
        :return: 结果对象
        """
        return mvrwindow_api.write_border_color(device_id, mvr_id, window_id, params)

    def mvr_window_umd_enable_write(self, device_id, mvr_id, window_id, params):
        """
        设置umd基本信息
        :param params: umd基本信息
        :param device_id:设备Id
        :param mvr_id: mvr id
        :param window_id: 窗口id
        :return:  结果对象
        """
        return mvrwindow_api.write_umd_enable(device_id, mvr_id, window_id, params)

    def mvr_window_umd_color_write(self, device_id, mvr_id, window_id, params):
        """
        设置窗口umd信息
        :param params: 窗口信息
        :param device_id:设备Id
        :param mvr_id: mvr id
        :param window_id: 窗口id
        :return: 结果对象
        """
        return mvrwindow_api.write_umd_color(device_id, mvr_id, window_id, params)

    def mvr_window_detail_read(self, device_id, mvr_id, window_id):
        """
        读取接口详细信息
        :param device_id:设备Id
        :param mvr_id: mvr id
        :param window_id: 窗口id
        :return: 参考前端接口文档
        """
        return mvrwindow_api.read_detail(device_id, mvr_id, window_id)

    def mvr_window_delete_batch(self, device_id, mvr_id, model, window_id_list):
        """
        批量删除预监窗口
        :param device_id: 设备Id
        :param mvr_id:  mvr Id
        :param model:  0 删除全部， 1 删除指定Id
        :param window_id_list:  id list
        :return:  结果对象
        """
        # 查询mvrWindow列表
        rs = self.mvr_window_list_read(device_id, mvr_id)
        if rs['status'] == 0 and rs['data']:
            windows = rs['data']['MVRWindows']
            if not windows:
                return get_result_model()
        else:
            return get_result_model(ResInfo.MVR_Window_List_Error)

        windows = [x['windowId'] for x in rs['data']['MVRWindows']]
        if model == 1:
            windows = [x for x in windows if x in window_id_list]

        del_list = []
        partial = False
        if windows:
            # 循环删除
            for w_id in windows:
                data = {
                    'deviceId': device_id,
                    'MVRId': mvr_id,
                    'windowId': w_id
                }
                rs = mvrwindow_api.write_delete(device_id, mvr_id, w_id, data)
                # 部分成功
                if rs['status'] != 0:
                    logger.error("mvr_window_delete_batch error windowId:"+str(w_id) + ",msg:" + rs['msg'])
                    partial = True
                data['status'] = rs['status']
                del_list.append(data)
        rs = get_result_model()
        if partial:
            rs = get_result_model(ResInfo.MVR_Window_Batch_Delete_Partial_Success)
        rs['data'] = del_list
        return rs

    def mvr_window_write_source(self, device_id, mvr_id, window_id, params):
        """
        预监切源，参考接口文档writeSource
        :param device_id: 设备Id
        :param mvr_id: mvrId
        :param window_id: windowId
        :param params: 参数
        :return: 结果对象
        """
        return mvrwindow_api.write_source(device_id, mvr_id, window_id, params)

    def mvr_window_write_info(self, device_id, mvr_id, window_id, params):
        """
        设置预监窗口信息
        umd停用启用、umd颜色、边框宽度、边框颜色
        :param device_id: 设备Id
        :param mvr_id: mvrId
        :param window_id: windowId
        :param params: 参数
        :return: 结果对象
        """
        data = {
            'deviceId': device_id,
            'MVRId': mvr_id,
            'windowId': window_id
        }
        # umd 信息
        umd = params.get('umd')
        if umd:
            if umd.get('umdEnable') is not None:
                data['umdEnable'] = umd.get('umdEnable')
                mvrwindow_api.write_umd_enable(device_id, mvr_id, window_id, data)
                data.pop('umdEnable')
            if umd.get('fontColor') is not None:
                data['fontColor'] = umd.get('fontColor')
                mvrwindow_api.write_umd_color(device_id, mvr_id, window_id, data)
                data.pop('fontColor')
        # 窗口信息
        window = params.get('window')
        if window:
            if window.get('borderWidth') is not None:
                data['borderWidth'] = window.get('borderWidth')
                mvrwindow_api.write_border_width(device_id, mvr_id, window_id, data)
                data.pop('borderWidth')
            if window.get('borderColor'):
                color = window.get('borderColor')
                data['R'] = color.get('R')
                data['G'] = color.get('G')
                data['B'] = color.get('B')
                mvrwindow_api.write_border_color(device_id, mvr_id, window_id, data)

        return get_result_model()

    def mvr_window_create_batch(self, device_id, mvr_id, params):
        rs = self.mvr_window_list_read(device_id, mvr_id)
        if rs['status'] != 0:
            return get_result_model(ResInfo.MVR_Window_List_Error)

        windows = [x['windowId'] for x in rs['data']['MVRWindows']]

        del_list = []
        partial = False
        if windows:
            # 循环删除
            for w_id in windows:
                data = {
                    'deviceId': device_id,
                    'MVRId': mvr_id,
                    'windowId': w_id
                }
                rs = mvrwindow_api.write_delete(device_id, mvr_id, w_id, data)
                # 部分成功
                if rs['status'] != 0:
                    partial = True
                data['status'] = rs['status']
                del_list.append(data)

        create_res = []
        if not partial:
            wins = params['windows']
            for win in wins:
                win['deviceId'] = device_id
                win['mvrId'] = mvr_id
            rs = mvrwindow_api.write_create(device_id, mvr_id, wins)
            if rs['status'] != 0:
                logger.info("mvr_window_create_batch response" + str(rs) + ",req:" + str(wins))

        rs = get_result_model()
        rs['data'] = {
            "delRes": del_list,
            'createRes': create_res
        }
        return rs

    def mvr_window_read_group_list(self, device_id, mvr_id):
        rs = mvrwindow_api.mvr_window_read_group_list(device_id, mvr_id)
        if rs['status'] != 0 or not rs['data']:
            return rs
        des = rs
        enable =  0
        for group in des['data']['mvrGroupList']:
            group_id = group['mvrGroupId']
            group_poll_rs = mvrwindow_api.mvr_window_group_poll_read(device_id, mvr_id)
            if group_poll_rs['status'] != 0 or not group_poll_rs['data']:
                continue
            if group_poll_rs['data']['enable'] == 1:
                enable =1
                group['enable'] = enable
            else:
                group['enable'] = enable
            group_node = mvrwindow_api.mvr_window_group_node_list(device_id, mvr_id, group_id)
            if group_node['status'] == 0 and group_node['data']:
                group['inputList'] = group_node['data']['inputList']
        return des


    def mvr_window_group_create(self, device_id, mvr_id, data):
        return mvrwindow_api.mvr_window_group_create(device_id, mvr_id, data)

    def mvr_window_group_delete(self, device_id, mvr_id, group_id, data):
        return mvrwindow_api.mvr_window_group_delete(device_id, mvr_id, group_id, data)

    def mvr_window_group_update(self, device_id, mvr_id, group_id, data):
        return mvrwindow_api.mvr_window_group_update(device_id, mvr_id, group_id, data)

    def mvr_window_group_node_list(self, device_id, mvr_id, group_id):
        return mvrwindow_api.mvr_window_group_node_list(device_id, mvr_id, group_id)

    def mvr_window_group_node_create(self, device_id, mvr_id, group_id, data):
        return mvrwindow_api.mvr_window_group_node_create(device_id, mvr_id, group_id, data)

    def mvr_window_group_node_delete(self, device_id, mvr_id, group_id, data):
        return mvrwindow_api.mvr_window_group_node_delete(device_id, mvr_id, group_id, data)

    def mvr_window_group_poll_read(self, device_id, mvr_id):
        return mvrwindow_api.mvr_window_group_poll_read(device_id, mvr_id)

    def mvr_window_write_group_play(self, device_id, data):
        return mvrwindow_api.mvr_window_write_group_play(device_id, data)

    def mvr_window_write_group_poll(self, device_id, group_id, enable, data):
        return mvrwindow_api.mvr_window_write_group_poll(device_id, group_id, enable, data)

mvr_window_svc = MvrWindowSvc()
