"""
Created on 2021年10月20日
@author: 程声清
"""
# 组装坐标偏移数据


def assembly_data(interfaces_list):
    """
    组装数据
    :param interfaces_list: 接口数据
    :return:  x,y
    """
    a = []
    b = []
    for interface in interfaces_list:
        a.append(interface['x'])
        b.append(interface['y'])
    x = min(a)
    y = min(b)
    return x, y


def cutting_data(start, end, ip_list):
    """
    切割组装数据
    :param start: start
    :param end: end
    :param ip_list: onvif ip地址
    :return:
    """
    list_ip = []
    ips = []
    if start != "":
        list_ip.append(start)
    if start != "" and end != "":
        a1, b1 = start.rsplit('.', 1)
        a2, b2 = end.rsplit('.', 1)
        b1, b2 = int(b1), int(b2)
        if a1 != a2 or b1 > b2:
            return None
        for i in range(b1, b2 + 1):
            ips.append(a1 + '.' + str(i))
    for get_arr in ip_list:
        list_ip.append(get_arr)
    for ip in ips:
        list_ip.append(ip)
    return list(dict.fromkeys(list_ip))


def cutting_ips(ips):
    """
    切割组装数据
    :param ips: ips
    :return:
    """
    start = ips['start']
    end = ips['end']
    return start, end


def repeated_judgment(arr):
    """
    判断列表所有元素是否相同
    :param arr: arr
    :return:
    """
    length = len(set(arr))
    # if length == 1:
    #     return length
    # else:
    return length


def remove_param(arr):
    """
    移除列表中指定元素
    :param arr: arr
    :return:
    """
    brr = set(arr)
    if 2 in brr:
        brr.remove(2)
    if 3 in brr:
        brr.remove(3)
    if 4 in brr:
        brr.remove(4)
    if 5 in brr:
        brr.remove(5)
    if 6 in brr:
        brr.remove(6)
    return len(list(brr))


def cutting_ip_data(start, end, ip_list):
    """
    切割组装数据
    :param start: start
    :param end: end
    :param ip_list: ip_list
    :return:
    """
    list_ip = []
    ips = []
    if start != "":
        list_ip.append(start)
    if start != "" and end != "":
        a1, b1 = start.rsplit('.', 1)
        a2, b2 = end.rsplit('.', 1)
        b1, b2 = int(b1), int(b2)
        if a1 != a2 or b1 > b2:
            return None
        for i in range(b1, b2 + 1):
            ips.append(a1 + '.' + str(i))
    for get_arr in ip_list:
        list_ip.append(get_arr)
    for ip in ips:
        list_ip.append(ip)
    s1 = set(list_ip)
    return sorted(s1)


def slot_transformation_input(slot_ids):
    """
    槽位号转换到input_id
    :param start: start
    :param end: end
    :param ip_list: ip_list
    :return:
    """
    input_ids = []
    if slot_ids:
        for slot in slot_ids:
            slot_1 = slot * 4
            input_ids.append(slot_1)
            slot_2 = slot * 4 + 1
            input_ids.append(slot_2)
            slot_3 = slot * 4 + 2
            input_ids.append(slot_3)
            slot_4 = slot * 4 + 3
            input_ids.append(slot_4)
    return input_ids

def remove_element_in_place(arr, elem):
    for i in reversed(range(len(arr))):
        if arr[i] == elem:
            arr.pop(i)
    return arr