"""
@Project ：h_series 
@File    ：jwt_token.py
@IDE     ：PyCharm 
@Author  ：程声清
@Date    ：2023/5/11 15:17 
"""
import base64
import hmac
import time
import json
import copy

KEY = 'mHAxsLYz'
ALGORITHM = 'SHA256'
SIGN = 'HYNAMIC'
EXP = 300


def jwt_encode(self_payload):
    # self_payload  含有私有声明的字典
    # key 自定的key
    # exp 过期时间
    # 生成header
    header = {'alg': ALGORITHM,  # 所使用的加密算法方式
              'kid': KEY ,
              }
    header_json = json.dumps(header, separators=(',', ':'), sort_keys=True)
    header_json_base64 = b64encode(header_json.encode())
    # init payload
    self_payload_copy = copy.deepcopy(self_payload)
    # 给拷贝出来的字典中加入公有声明
    self_payload_copy["exp"] = time.time() + EXP  # 过期时间
    self_payload_copy_json = json.dumps(self_payload_copy, separators=(',', ':'), sort_keys=True)
    self_payload_copy_json_base64 = b64encode(self_payload_copy_json.encode())
    hm = hmac.new(KEY.encode(), header_json_base64 + b'.' + self_payload_copy_json_base64,
                  digestmod=ALGORITHM)
    hm_base64 = b64encode(hm.digest())
    return str((header_json_base64 + b'.' + self_payload_copy_json_base64 + b'.' + hm_base64), encoding='utf-8')

def b64encode(js):  # 将base64转换修改为urlsafe
    return base64.urlsafe_b64encode(js).replace(b"=", b"")

def b64decode(bs):
    # 加回来等号
    rem = len(bs) % 4  # 取余
    if rem > 0:
        bs += b'=' * (4 - rem)
    return base64.urlsafe_b64decode(bs)

def jwt_decode(token):
    # 传入jwt的值(令牌) 和只有调用者知道的key
    # 校验签名
    header_bs, payload_bs, signature_bs = token.split(b".")  # 因为是字节串
    hm = hmac.new(KEY.encode(), header_bs + b"." + payload_bs, digestmod=ALGORITHM)
    if signature_bs != b64encode(hm.digest()):  # 将签名结果和传过来的sign进行对比
        raise RuntimeError('签名验证错误')
    # 校验时间
    payload_js = b64decode(payload_bs)  # 解码为json
    payload = json.loads(payload_js)  # 解码为字典
    now = time.time()  # 当前时间
    if int(now) > int(payload["exp"]):  # 登录时间过期
        raise RuntimeError('登陆时间过期')
    return payload  # 返回自定义内容


if __name__ == '__main__':
    # 测试
    s = jwt_encode({"name": "csq"})  # 制作令牌
    print(jwt_decode(s))  # 校验令牌 返回payload明文 字典类型



