"""
Created on 2019年6月28日
@author: 刘益宗
日志装饰器
"""
import time
from functools import wraps
from flask.globals import request
from flask.json import jsonify

from H_9U.util.log import logger
from flask.globals import g


# api 日志装饰器


def api_log(func):
    """
    api日志装饰器，用于api
    :param func: 装饰函数
    :return:  原函数返回值
    """
    @wraps(func)
    def wrapper(*args, **kwargs):
        # 调用时间
        start = time.monotonic()
        # 请求参数
        req_str = ''
        try:
            req_str = request.get_data().decode()
        except:
            pass
        # 调用原函数
        t = jsonify({'status': 500, 'msg': 'Server_Err', 'data': {}})
        try:
            t = func(*args, **kwargs)
        except Exception as e:
            logger.exception(e)
            logger.error("API:%s,%s---接口:%s出现异常，请求：%s,异常消息：%s" %
                         (g.user['username'] if 'user' in g else "anony",
                          g.ip,
                          func.__name__,
                          req_str,
                          str(e)))
        # 调用时间
        sec = time.monotonic() - start
        # 记录日志
        logger.info("API:%s,%s---接口:%s，请求：%s,返回：%s，耗时：%s %s" %
                    (g.user['username'] if 'user' in g else "anony",
                     g.ip,
                     func.__name__,
                     "", t, str(sec), ',耗时异常' if sec > 3 else ''))

        return t

    return wrapper


def open_log(func):
    """
    api日志装饰器，用于api
    :param func: 装饰函数
    :return:  原函数返回值
    """
    @wraps(func)
    def wrapper(*args, **kwargs):
        # 调用时间
        start = time.monotonic()
        # 请求参数
        req_str = ''
        try:
            req_str = request.get_data().decode()
        except:
            pass
        # 调用原函数
        t = jsonify({'status': 500, 'msg': 'Server_Err', 'data': {}})
        try:
            t = func(*args, **kwargs)
        except Exception as e:
            logger.exception(e)
            logger.error("%s: OpenAPI接口%s出现异常，请求：%s,异常消息：%s" % (g.project_name, func.__name__, req_str, str(e)))
        # 调用时间
        sec = time.monotonic() - start
        # 记录日志
        logger.info("%s: OpenAPI接口%s，请求：%s,返回：%s，耗时：%s %s" % (g.project_name, func.__name__, "", t, str(sec), ',耗时异常' if sec > 3 else ''))
        return t

    return wrapper

# 日志装饰器
def log_wrapper(func):
    """
    日志装饰器,用于所有函数
    :param func: 装饰函数
    :return:  原函数返回值
    """
    @wraps(func)
    def wrapper(*args, **kwargs):
        # 调用时间
        start = time.monotonic()
        # 调用原函数
        try:
            t = func(*args, **kwargs)
        except Exception as e:
            logger.exception(e)
            logger.error("接口%s异常，请求args:%s,请求kwargs:%s, 异常信息：%s" % (func.__name__, str(args), str(kwargs), str(e)))
            t = {'status': 500, 'msg': '', 'data': {}}
        # 调用时间
        sec = time.monotonic() - start
        # 记录日志
        # # logger.debug(
        #     "接口%s，请求args:%s,请求kwargs:%s,返回：%s，耗时：%s" % (func.__name__, str(args), str(kwargs), str(t), str(sec)))

        if t['status'] != 0 or sec > 3:
            logger.info("接口%s，请求args:%s,请求kwargs:%s,返回：%s，耗时：%s %s" %
                        (func.__name__, str(args), str(kwargs), t, str(sec), ',耗时异常' if sec > 3 else ''))
        else:
            logger.info("接口%s，请求args:%s,请求kwargs:%s,返回：%s，耗时：%s" %
                        (func.__name__, "", "", t['status'], str(sec)))
        return t

    return wrapper
