from H_9U.util.log import logger

nginx_config = """
   
    upstream wsMvrConfig{ 
        server {#IP#}:7999;
        keepalive 1000; 
    }

    server { 
        listen 7999 ssl;
        server_name _;
        ssl_certificate  /etc/cert/server.crt; # 证书的名字
        ssl_certificate_key /etc/cert/ca.key; #证书的名字
        ssl_session_timeout 20m;
        ssl_protocols TLSv1.2; # Dropping SSLv3, ref: POODLE
        ssl_prefer_server_ciphers on;
        ssl_ciphers ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA:ECDHE-RSA-AES256-SHA:DHE-RSA-AES256-SHA256:DHE-RSA-AES256-SHA:!SHA1:!SHA256:!SHA384:!DSS:!aNULL;
        ssl_verify_client off;        
        location /configVideo { 
            proxy_http_version 1.1; 
            proxy_pass http://wsMvrConfig; 
            proxy_redirect off;
            proxy_set_header Host $host; 
            proxy_set_header X-Real-IP $remote_addr; 
            proxy_read_timeout 3600s; 
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for; 
            proxy_set_header Upgrade $http_upgrade; 
            proxy_set_header Connection $connection_upgrade; 
        } 
    }

    upstream wsEchoVideo{ 
        server {#ECHO#};
        keepalive 1000; 
    }

    server { 
        listen 8083 ssl;
        server_name _;
        ssl_certificate  /etc/cert/server.crt; # 证书的名字
        ssl_certificate_key /etc/cert/ca.key; #证书的名字
        ssl_session_timeout 20m;
        ssl_protocols TLSv1.2; # Dropping SSLv3, ref: POODLE
        ssl_prefer_server_ciphers on;
        ssl_ciphers ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA:ECDHE-RSA-AES256-SHA:DHE-RSA-AES256-SHA256:DHE-RSA-AES256-SHA:!SHA1:!SHA256:!SHA384:!DSS:!aNULL;
        ssl_verify_client off;        
        location / { 
            proxy_http_version 1.1; 
            proxy_pass http://wsEchoVideo; 
            proxy_redirect off;
            proxy_set_header Host $host; 
            proxy_set_header X-Real-IP $remote_addr; 
            proxy_read_timeout 3600s; 
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for; 
            proxy_set_header Upgrade $http_upgrade; 
            proxy_set_header Connection $connection_upgrade; 
        } 
    }

    upstream wsMvrVideo{ 
        server {#MVR#};
        keepalive 1000; 
    }

    server { 
        listen 8082 ssl;
        server_name _;
        ssl_certificate  /etc/cert/server.crt; # 证书的名字
        ssl_certificate_key /etc/cert/ca.key; #证书的名字
        ssl_session_timeout 20m;
        ssl_protocols TLSv1.2; # Dropping SSLv3, ref: POODLE
        ssl_prefer_server_ciphers on;
        ssl_ciphers ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA384:ECDHE-ECDSA-AES256-SHA:ECDHE-RSA-AES256-SHA:DHE-RSA-AES256-SHA256:DHE-RSA-AES256-SHA:!SHA1:!SHA256:!SHA384:!DSS:!aNULL;
        ssl_verify_client off;        
        location / { 
            proxy_http_version 1.1; 
            proxy_pass http://wsMvrVideo; 
            proxy_redirect off;
            proxy_set_header Host $host; 
            proxy_set_header X-Real-IP $remote_addr; 
            proxy_read_timeout 3600s; 
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for; 
            proxy_set_header Upgrade $http_upgrade; 
            proxy_set_header Connection $connection_upgrade; 
        }
    }
"""


def _wss_nginx_config(ip, echo_url, mvr_url):
    """
    nginx wss 配置
    """
    return nginx_config.replace("{#IP#}", ip).replace("{#ECHO#}", echo_url).replace("{#MVR#}", mvr_url)


def nginx_reload():
    """
    重启nginx
    """
    import os
    try:
        os.system("nginx -s reload")
    except Exception as e:
        print("reload nginx error:", e)
        logger.error("nginx reload error")
        logger.error(e)


def set_nginx_and_reload(ip, echo_path, mvr_path):
    """
    配置nginx并重启
    """

    try:
        config = _wss_nginx_config(ip, ip + ":" + echo_path, ip + ":" + mvr_path)
        with open(r"/etc/nginx/conf.d/ws_nginx.conf", 'w') as f:
            f.write(config)
    except Exception as e:
        logger.error("nginx config error")
        logger.error(e)
    nginx_reload()
