"""
Created on 2021年9月09日
@author: 程声清
请求参数与返回参数处理

"""
from flask import g
from H_9U.util.signature_encryption import des_encrypt, signature_encrypt_res


def request_parameter_resolution(params):
    """
     校验请求参数
    :params : params 主要是 pId  sign timeStamp body
    :return: 返回判断结果
    """
    if params is None:
        is_valid = False
    else:
        if (params['pId'] or params['sign'] or params['timeStamp'] or params['body']) is None:
            is_valid = False
        else:
            is_valid = True
    return is_valid


def response_parameter_resolution(response_data):
    """
     响应参数加密
    :param response_data
    :return: 返回解析后的明文
    """
    is_encrypt = g.is_encrypt
    status = response_data['status']
    msg = response_data['msg']
    body = response_data['data']
    if is_encrypt == 1:
        p_id = g.pId
        secret_key = g.secretKey
        encrypt_value = des_encrypt(body, secret_key)
        sign = signature_encrypt_res(encrypt_value, p_id, secret_key)
        return {"status": status, "msg": msg, "sign": sign, "body": encrypt_value}
    if is_encrypt == 0:
        return {"status": status, "msg": msg, "sign": "", "body": body}